RitchieBaleLeftEvent = {};
RitchieBaleLeftEvent_mt = Class(RitchieBaleLeftEvent, Event);

InitEventClass(RitchieBaleLeftEvent, "RitchieBaleLeftEvent");

function RitchieBaleLeftEvent:emptyNew()
    local self = Event:new(RitchieBaleLeftEvent_mt);
    self.className="RitchieBaleLeftEvent";

    return self;
end;

function RitchieBaleLeftEvent:new(vehicle, baleId)
    local self = RitchieBaleLeftEvent:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleLeftEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleLeftEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleLeftEvent:run(connection)
	self.vehicle:setBaleLeft(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleLeftEvent:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleLeftEvent.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleLeftEvent:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleLeftEvent:new(vehicle, baleId));
		end;
	end;
end;