RitchieBaleLeft2Event = {};
RitchieBaleLeft2Event_mt = Class(RitchieBaleLeft2Event, Event);

InitEventClass(RitchieBaleLeft2Event, "RitchieBaleLeft2Event");

function RitchieBaleLeft2Event:emptyNew()
    local self = Event:new(RitchieBaleLeft2Event_mt);
    self.className="RitchieBaleLeft2Event";

    return self;
end;

function RitchieBaleLeft2Event:new(vehicle, baleId)
    local self = RitchieBaleLeft2Event:emptyNew()
    self.vehicle = vehicle;
	self.baleId = baleId;

    return self;
end;

function RitchieBaleLeft2Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);

    self.baleId = streamReadInt32(streamId);

    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function RitchieBaleLeft2Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));

	streamWriteInt32(streamId, self.baleId);
end;

function RitchieBaleLeft2Event:run(connection)
	self.vehicle:setBaleLeft2(self.baleId, true);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RitchieBaleLeft2Event:new(self.vehicle, self.baleId), nil, connection, self.object);
	end;
end;

function RitchieBaleLeft2Event.sendEvent(vehicle, baleId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RitchieBaleLeft2Event:new(vehicle, baleId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RitchieBaleLeft2Event:new(vehicle, baleId));
		end;
	end;
end;