TaarupULW = {};

TaarupULW.UNLOADING_CLOSED = 0;
TaarupULW.UNLOADING_OPEN = 1;

function TaarupULW.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function TaarupULW:load(xmlFile)
self.isShovel = true;
	self.toggleUnloadingState = SpecializationUtil.callSpecializationsFunction("toggleUnloadingState");
  	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
		self.setUnloadingState = SpecializationUtil.callSpecializationsFunction("setUnloadingState");
	self.findTrailerRaycastCallback = TaarupULW.findTrailerRaycastCallback;
    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
    self.pipeParticleSystem = {};
    self.pipeParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeParticleSystem#index"));
    Utils.loadParticleSystem(xmlFile, self.pipeParticleSystem, "vehicle.pipeParticleSystem", self.pipeParticleSystemindex, false, nil, self.baseDirectory);
    local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if pipeSound ~= nil and pipeSound ~= "" then
        pipeSound = Utils.getFilename(pipeSound, self.baseDirectory); 
        self.pipeSound = createSample("pipeSound");
        loadSample(self.pipeSound, pipeSound, false);
        self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
        self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
        self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
	  self.pipeSoundEnabled = false;
    end;
	self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
	self.grainUnloading = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainUnloading"), 10);
	self.hudHawepath = Utils.getFilename("taarupControl.png", self.baseDirectory);
	self.hudHawePoxX = 0.501;
    self.hudHawePoxY = 1-0.204;
    self.hudHaweWidth = 0.256;
    self.hudHaweHeight = 0.256;
	self.hudBasePoxX = 0.531;
    self.hudBasePoxY = 0.9069; --1-0.094; 0.907 0.001
    self.hudHaweOverlay = Overlay:new("hudTaarupControl", self.hudHawepath, self.hudHawePoxX, self.hudHawePoxY, self.hudHaweWidth, self.hudHaweHeight);
	self.pipeParticleActivated = false;
	self.activeUnloading = false;
	self.isActive = false;
	self.allowunload = false;
	self.haechsell = false;
	self.open = false;
	self.saveMinRpm = 0;
	local path = Utils.getFilename("overlay.png", self.baseDirectory);
    self.unloadingOverlay = Overlay:new("hudPDAControl", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY+0.11, g_currentMission.fruitSymbolSize, g_currentMission.fruitSymbolSize * (4 / 3)); 

end;

function TaarupULW:delete()
	if self.hudHaweOverlay ~= nil then
		self.hudHaweOverlay:delete();
	end;
end;

function TaarupULW:readStream(streamId, connection)
	self.isLoading = true;
	local activeUnloading = streamReadBool(streamId);
	self:setUnloadingState(activeUnloading, true);
end;

function TaarupULW:writeStream(streamId, connection)
	streamWriteBool(streamId, self.activeUnloading);
end;

function TaarupULW:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TaarupULW:keyEvent(unicode, sym, modifier, isDown)
end;

function TaarupULW:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.Taarup_con) then
			self.bcActive = not self.bcActive;
		end;
		if InputBinding.hasEvent(InputBinding.Taarup_haechsel) then
			if self.haechsell then
				self:setAnimationTime(3, self.animationParts[3].offSet, false);
			else
				self:setAnimationTime(3, self.animationParts[3].animDuration, false);
			end;
		end;	
		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			if self.unloadingState == TaarupULW.UNLOADING_OPEN then
				self:setAnimationTime(1, self.animationParts[1].offSet, false);
				self:setUnloadingState(false);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration, false);
				self.open = true;
			end;
		end;
	end;
	if self.animationParts[1].inputDone and self.animationParts[1].clipEndTime then
		self.unloadingState = TaarupULW.UNLOADING_OPEN;
		self.open = false;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) and self:getIsActiveForInput() then
			if self.allowunload then
				self:setAnimationTime(2, self.animationParts[2].offSet, false);
			else
				self:setAnimationTime(2, self.animationParts[2].animDuration, false);
			end;
		end;
		if self.allowunload then
			if InputBinding.hasEvent(InputBinding.Taarup_ulv) and self:getIsActiveForInput() then
				self.pipeParticleActivated = not self.pipeParticleActivated;
				self:setUnloadingState(not self.activeUnloading);
			end;
		end;
	elseif not self.animationParts[1].clipEndTime  then
		self:setAnimationTime(2, self.animationParts[2].startPosition, false);
		self.unloadingState = TaarupULW.UNLOADING_CLOSED;
	end;	
	if self.animationParts[2].inputDone and self.animationParts[2].clipEndTime then
		self.allowunload = true;
	elseif not self.animationParts[2].clipEndTime then
		self.allowunload = false;
	end;
	
	if self.animationParts[3].inputDone and self.animationParts[3].clipEndTime then
		self.haechsell = true;
	elseif not self.animationParts[3].clipEndTime then
		self.haechsell = false;
	end;


	local pipeSoundEnabled = false;
	for i=1, 3 do
		if not self.animationParts[i].inputDone then
			pipeSoundEnabled = true;
		end;
	end;
	if pipeSoundEnabled then
		if not self.pipeSoundEnabled and self.pipeSound ~= nil and self:getIsActiveForSound() then
			setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
			playSample(self.pipeSound, 0, 1, 0);
			self.pipeSoundEnabled = true;
		end;
	else
		if self.pipeSoundEnabled then
			stopSample(self.pipeSound);
			self.pipeSoundEnabled = false; 
		end;
	end;
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;

end;

function TaarupULW:updateTick(dt)
	local rpmup = false;
	self.trailerFound = nil;
	local object = nil;
	local nearestDistance = 3.0;
	if self.fillLevel > 0 and self.unloadingState == TaarupULW.UNLOADING_OPEN then
		local x, y, z = getWorldTranslation(self.trailerPosition);
		local dx, dy, dz = localDirectionToWorld(self.trailerPosition, 0, -0.1, 0);
		raycastAll(x, y, z, dx, dy, dz, "findTrailerRaycastCallback", 3, self);	
		

		if g_currentMission.modMapShovelTrigger ~= nil then 
			local px, py, pz = getWorldTranslation(self.trailerPosition);
			for i=1, table.getn(g_currentMission.modMapShovelTrigger) do
				local vx, vy, vz = getWorldTranslation(g_currentMission.modMapShovelTrigger[i].emptyNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					object = g_currentMission.modMapShovelTrigger[i];
				end;
			end;
		end;
	end;
	if self:getIsActive() then
		local renderOverlay = false;
		local deltaLevel = 0;
		if object ~= nil then
			if object.fillLevel ~= nil and object.capacity ~= nil and object.setFillLevel ~= nil and object.allowFillType ~= nil then
				if object.fillLevel < object.capacity and self.fillLevel > 0 and object:allowFillType(self.currentFillType, true) then		
					if self.activeUnloading then
						rpmup = true
						deltaLevel = math.min(self.grainUnloading*dt/1000.0, object.capacity-object.fillLevel);
						object:setFillLevel(object.fillLevel + deltaLevel, self.currentFillType);
					else
						renderOverlay = true;
					end;
				end;
			end;
		elseif self.trailerFound ~= nil and self.trailerFound ~= 0 then
			local trailer = g_currentMission.nodeToVehicle[self.trailerFound];
			if trailer ~= nil and trailer:allowFillType(self.currentFillType, true) and trailer.capacity ~= trailer.fillLevel then
				if self.activeUnloading then
					rpmup = true
					deltaLevel = math.min(self.grainUnloading*dt/1000.0, trailer.capacity-trailer.fillLevel);
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
				else
					renderOverlay = true;
				end;
			elseif self.activeUnloading then
				self:setUnloadingState(false);
			end;
		end;
		self.fillLevel = self.fillLevel-deltaLevel;
		if deltaLevel == 0 and self.activeUnloading then
			self:setUnloadingState(false);
		end;
		if self.fillLevel <= 0.0 then
			self.fillLevel = 0.0;
			if self.activeUnloading then
				self:setUnloadingState(false);
			end;
			Utils.setEmittingState(self.pipeParticleSystem, self.activeUnloading);
			self.currentFillType = Fillable.FRUITTYPE_UNKNOWN;
		end;
		self:setFillLevel(self.fillLevel, self.currentFillType);
		self.renderOverlay = renderOverlay;
		Utils.setEmittingState(self.pipeParticleSystem, self.activeUnloading);		
	end;
	if self.open then
		rpmup = true
	end;
	self:setVehicleRpmUp(dt, rpmup);
end;


function TaarupULW:draw()	
	if self.attacherVehicle ~= nil then
		if self.unloadingState == TaarupULW.UNLOADING_OPEN then
			g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_2"), InputBinding.IMPLEMENT_EXTRA2);
			if self.animationParts[1].inputDone then
				if self.allowunload then
					g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_4"), InputBinding.IMPLEMENT_EXTRA3);
				elseif self.renderOverlay then
					self.unloadingOverlay:render();
					g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_3"), InputBinding.IMPLEMENT_EXTRA3);
				end;
				if self.activeUnloading and self.pipeParticleActivated then
					g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_6"), InputBinding.Taarup_ulv);
				elseif self.renderOverlay and self.allowunload then
					self.unloadingOverlay:render();
					g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_5"), InputBinding.Taarup_ulv);
				end;
			end;
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_1"), InputBinding.IMPLEMENT_EXTRA2);
		end;
		if self.haechsell then
			g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_10"), InputBinding.Taarup_haechsel);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_9"), InputBinding.Taarup_haechsel);
		end;		
		if self.bcActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_8"), InputBinding.Taarup_con);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Taarup_7"), InputBinding.Taarup_con);
		end;

		if self.bcActive and self.hudHaweOverlay ~= nil then
			self.hudHaweOverlay:render();
			setTextBold(true);
			setTextColor(0.8, 0.2, 0.2, 1.0);
			local text = "";
			local massPerLiter = 800/1000; -- 800 kg per 1000 liter chaff (chaff-density)
			local mass = self.fillLevel*massPerLiter;
			local fillLevelString = "asd";
			if mass >= 0 and mass < 10 then
				fillLevelString = "0000" .. string.format("%d", mass);
			elseif mass >= 10 and mass < 100 then
				fillLevelString = "000" .. string.format("%d", mass);
			elseif mass >= 100 and mass < 1000 then
				fillLevelString = "00" .. string.format("%d", mass);
			elseif mass >= 1000 and mass < 10000 then
				fillLevelString = "0" .. string.format("%d", mass);
			elseif mass >= 10000 and mass < 50000 then
				fillLevelString = string.format("%d", mass);
			else
				fillLevelString = "ERROR";
			end;
			renderText(self.hudBasePoxX, self.hudBasePoxY, 0.070, fillLevelString);
			renderText(self.hudBasePoxX+0.145, self.hudBasePoxY+0.007, 0.06, "kg");
		end;
	end;
end;

function TaarupULW:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function TaarupULW:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;
function TaarupULW:setUnloadingState(state, noEventSend)
	SetUnloadingEvent.sendEvent(self, state, noEventSend);
	self.activeUnloading = state;
end;

function TaarupULW:findTrailerRaycastCallback(transformId, x, y, z, distance)
	local trailer = g_currentMission.nodeToVehicle[transformId];
	if trailer ~= nil and trailer ~= self then
		if trailer.exactFillRootNode == transformId  then
			self.trailerFound = transformId;
			return false;
		end;
	end;
	return true;
end;
function TaarupULW:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;