-- This Script is for the Kverneland NGH 301 Machine from VWFahrer80[www.ls-moddingwelt.eu]
-- author: Marvin P. (ihc-433[www.ls-moddingwelt.eu])
-- date: 27.05.2011
-- Version: 1.0
-- 
-- Do not modify without my consent

NGH = {};

function NGH.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function NGH:load(xmlFile)		
	self.HydroLift = false;
	self.HydroLift_allowed = false;
	self.Lowering = false;
	self.Lowering_mouse = false;
	self.Lowering_mouse_allowed = false;
	self.updateJoint = false;
	self.cursor = false;
	self.mousePosX = 0;
	self.mousePosY = 0;
	
	self.hud = {0.7,0.25,0.3,0.36};
	self.hud.On = false;
	self.hud.allowed = false;
	self.hud.size = 0.02;
	self.hud.Text = {};
	self.hud.Text.PosX = self.hud[1] + 0.02;
	self.hud.Text.PosY1 = self.hud[2]+0.2;
	self.hud.Text.size1 = 0.02;
	self.hud.Text.PosY2 = self.hud.Text.PosY1-self.hud.size;
	self.hud.Text.PosY3 = self.hud.Text.PosY2-self.hud.size;
	self.hud.Text.PosY4 = self.hud.Text.PosY3-self.hud.size;
	self.hud.Text.size4 = 0.02;
	self.hud.Text.PosY5 = self.hud.Text.PosY4-self.hud.size;
	self.hud.Text.size5 = 0.02;
	
	self.NGHOverlay = Overlay:new("NGHOverlay", Utils.getFilename("Hud.png", self.baseDirectory), self.hud[1], self.hud[2], self.hud[3], self.hud[4]);
		
	self.Tricks = {};
	local i = 0;
	while true do
		local BaseName = string.format("vehicle.tricks.trick(%d)", i);
		local index = getXMLString(xmlFile, BaseName .. "#index");
		local Trick = {};
		Trick.index = Utils.indexToObject(self.components, index);
		if Trick.index == nil then
			break;
		end;
			table.insert(self.Tricks, Trick.index);
		i = i+1;
	end;
	
			
end;

function NGH:delete()
end;

function NGH:readStream(streamId, connection)
	self.Lowering = streamReadBool(streamId);
	self.Lowering_mouse = streamReadBool(streamId);
	self.updateJoint = streamReadBool(streamId);
end;

function NGH:writeStream(streamId, connection)	
	streamWriteBool(streamId, self.Lowering);
	streamWriteBool(streamId, self.Lowering_mouse);
	streamWriteBool(streamId, self.updateJoint);
end;

function NGH:mouseEvent(posX, posY, isDown, isUp, button)
	if button == 1 then
		if isDown then
			if self.hud.On then
				if self.hud.allowed then
					self.hud.On = false;
				end;
				if not self.Lowering then
					if self.Lowering_mouse_allowed then
						self.Lowering_mouse = not self.Lowering_mouse;
						RotationEvent.sendEvent(self, self.Lowering_mouse, noEventSend);
					end;
				end;
				if self.HydroLift_allowed then
					self.HydroLift = not self.HydroLift;
				end;
			end;
		end;
	end;
	if posY > self.hud.Text.PosY4 and posY < math.abs(self.hud.Text.PosY4+self.hud.size) and posX > self.hud.Text.PosX and posX < 1  then
		self.hud.Text.size4 = self.hud.size+0.01;
		self.Lowering_mouse_allowed = true;
		else
		self.hud.Text.size4 = self.hud.size;	
		self.Lowering_mouse_allowed = false;
	end;
	if posY > self.hud.Text.PosY3 and posY < math.abs(self.hud.Text.PosY3+self.hud.size) and posX > self.hud.Text.PosX and posX < 1  then
		self.hud.Text.size1 = self.hud.size+0.01;
		self.hud.allowed = true;
		else
		self.hud.Text.size1 = self.hud.size;
		self.hud.allowed = false;
	end;
	if posY > self.hud.Text.PosY5 and posY < math.abs(self.hud.Text.PosY5+self.hud.size) and posX > self.hud.Text.PosX and posX < 1  then
		self.hud.Text.size5 = self.hud.size+0.01;
		self.HydroLift_allowed = true;
		else
		self.hud.Text.size5 = self.hud.size;	
		self.HydroLift_allowed = false;
	end;

	if button == 2 and isDown then
		self.cursor = not self.cursor;
	end;
	if self.cursor and self.hud.On then
		InputBinding.setShowMouseCursor(true);
		else
		InputBinding.setShowMouseCursor(false);
	end;
end;

function NGH:keyEvent(unicode, sym, modifier, isDown)
end;

function NGH:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.Lowering = not self.Lowering;
			RotationEvent.sendEvent(self, self.Lowering, noEventSend);
		end;
		if InputBinding.hasEvent(InputBinding.Hud) then
			self.hud.On = not self.hud.On;
		end;
		if self.HydroLift then
			self:setAnimationTime(1, self.animationParts[1].animDuration);
			local currentPos = self.animationParts[1].currentPosition;
			local duration = 5000;
			if currentPos < duration and currentPos > 70 then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
				else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
			else
			self:setAnimationTime(1, self.animationParts[1].offSet);		
			local currentPos = self.animationParts[1].currentPosition;
			local duration = 5000;
			if currentPos < duration and currentPos > 70 then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
				else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.ENTER) or InputBinding.hasEvent(InputBinding.SWITCH_VEHICLE) then
			InputBinding.setShowMouseCursor(false);
		end;
	end;
end;

function NGH:updateTick(dt)
	if self:getIsActiveForInput() then
		self.updateJoint = true;
	end;
	if self.attacherVehicle ~= nil then
		if self.Lowering then
			local k = self.movingDirection;
			if k == 0 or k == 1 then
				for i=1, table.getn(self.Tricks) do
					rotate(self.Tricks[i], 0,(0.2*self.attacherVehicle.motor.minRpm)/dt, 0);
				end;
				self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-0.002);
				g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal+0.0002 ;
				self.Lowering_mouse = false;
			end;
		end;
		if self.Lowering_mouse then
			for i=1, table.getn(self.Tricks) do
				rotate(self.Tricks[i], 0 ,(0.2*self.attacherVehicle.motor.minRpm)/dt, 0);
			end;
		end;
	end;
	UpdateJointEvent.sendEvent(self, self.updateJoint, noEventSend);
end;

function NGH:draw()
	if self:getIsActive() then
		if self.hud.On then
			local Hud = g_i18n:getText("Hud_off");
			self.NGHOverlay:render();
			setTextBold(true);
			renderText(self.hud.Text.PosX, self.hud.Text.PosY3, self.hud.Text.size1, Hud);
			if not self.Lowering then
				if self.Lowering_mouse then
					local Tricks_off = g_i18n:getText("Tricks_off");
					renderText(self.hud.Text.PosX, self.hud.Text.PosY4, self.hud.Text.size4, Tricks_off);
					else
					local Tricks_on = g_i18n:getText("Tricks_on");
					renderText(self.hud.Text.PosX, self.hud.Text.PosY4, self.hud.Text.size4, Tricks_on);
				end;
				else
				local Tricks_aktiv = g_i18n:getText("Tricks_aktiv");
				renderText(self.hud.Text.PosX, self.hud.Text.PosY4, self.hud.Text.size4, Tricks_aktiv);
			end;
			if self.HydroLift then
				self.buttonWidth = 0.03;
				self.buttonHeigth = 0.03;
				local HydroLift_down = g_i18n:getText("HydroLift_down");
				renderText(self.hud.Text.PosX, self.hud.Text.PosY5, self.hud.Text.size5, HydroLift_down);
				else
				local HydroLift_up = g_i18n:getText("HydroLift_up");
				renderText(self.hud.Text.PosX, self.hud.Text.PosY5, self.hud.Text.size5, HydroLift_up);
			end;
			if self.cursor then
				local Mouse_deaktiv = g_i18n:getText("Mouse_deaktiv");
				renderText(self.hud.Text.PosX, self.hud.Text.PosY2, self.hud.size, Mouse_deaktiv);
				else
				local Mouse_aktiv = g_i18n:getText("Mouse_aktiv");
				renderText(self.hud.Text.PosX, self.hud.Text.PosY2, self.hud.size, Mouse_aktiv);
			end;
			if self.hud.allowed or self.HydroLift_allowed or self.Lowering_mouse_allowed then
				local Mouse_right =g_i18n:getText("Mouse_right");
				renderText(self.hud.Text.PosX, self.hud.Text.PosY1, self.hud.size, Mouse_right);
			end;
		end;
		if not self.hud.On then
			g_currentMission:addHelpButtonText(g_i18n:getText("Hud"), InputBinding.Hud);
		end;
	end;
end;

function NGH:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function NGH:onDettach() 
	self.cursor = false;
end;

function NGH:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;