KLSEvent = {};
KLSEvent_mt = Class(KLSEvent, Event);

InitEventClass(KLSEvent, "KLSEvent");

function KLSEvent:emptyNew()
    local self = Event:new(KLSEvent_mt);
    self.className="KLSEvent";
    return self;
end;

function KLSEvent:new(object, data)
    local self = KLSEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function KLSEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.loweringTime = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(KLSEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function KLSEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;

function KLSEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(KLSEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(KLSEvent:new(vehicle, data));
	end;
end;