
--Written by Marvin "ihc-433" P.
--Date: 16.08.2012

KLS = {};

function KLS.prerequisitesPresent(specializations)
    return true; 
end;

function KLS:load(xmlFile)
	--Sttzen Trigger
	self.Trigger = KLS.Trigger;
	self.TriggerIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger#index"));
	addTrigger(self.TriggerIndex, "Trigger", self);
	self.enteredTrigger = false;

	self.stuetzenPosition = false;
	self.loweringTime = 0;
	self.loweringTime_boolean = false;
	self.buy = false;
	
	self.stuetze = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stuetze#index"));
	self.kaputteStuetze = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kaputteStuetze#index"));
end;

function KLS:Trigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		self.enteredTrigger = true;
	end;
	if onLeave then 
		self.enteredTrigger = false;
	end;
end; --Der Trigger funktioniert einwandfrei, so wie er soll !

function KLS:readStream(streamId, connection)
	self.loweringTime_boolean = streamReadBool(streamId);
end;

function KLS:writeStream(streamId, connection)	
	streamWriteBool(streamId, self.loweringTime_boolean);
end;

function KLS:delete()
	removeTrigger(self.TriggerIndex);
end;

function KLS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KLS:keyEvent(unicode, sym, modifier, isDown)
end;

function KLS:update(dt)
	if self.enteredTrigger then
		if not self.loweringTime_boolean then
			if InputBinding.hasEvent(InputBinding.stuetze) then
				self.stuetzenPosition = not self.stuetzenPosition;
			end;
			if self.stuetzenPosition then
				self:setAnimationTime(1, self.animationParts[1].animDuration); --Sttze wird hochgefahren
				g_currentMission:addHelpButtonText(g_i18n:getText("down"), InputBinding.stuetze);
				else
				self:setAnimationTime(1, self.animationParts[1].offSet); --Sttze wird herruntergefahren
				g_currentMission:addHelpButtonText(g_i18n:getText("up"), InputBinding.stuetze);
			end;
		end;
		if self.loweringTime_boolean then
			g_currentMission:addHelpButtonText(g_i18n:getText("kaufen"), InputBinding.buy);
			if InputBinding.hasEvent(InputBinding.buy) then
				self.buy = true;
			end;
		end;
	end;
	if self.loweringTime_boolean then
		setVisibility(self.stuetze, false);
		setVisibility(self.kaputteStuetze, true);
		if self.attacherVehicle ~= nil then
			self.attacherVehicle:stopAITractor();
			self.attacherVehicle.steeringEnabled = false;
			self.attacherVehicle.motor:setSpeedLevel(0, false);
			WheelsUtil.updateWheelsPhysics(self.attacherVehicle, 0, self.attacherVehicle.lastSpeed, 0, false, self.attacherVehicle.requiredDriveMode);
		end;
	end;
	
	if not self.loweringTime_boolean and self.attacherVehicle ~= nil then
		self.attacherVehicle.steeringEnabled = true;
	end;
	
	if InputBinding.isPressed(InputBinding.stuetze) and not self.loweringTime_boolean and self:getIsActiveForInput() then
		g_currentMission:addWarning(g_i18n:getText("aussteigen"));
	end;	
end;

function KLS:updateTick(dt)
	if self.cultivatorHasGroundContact and not self.stuetzenPosition then 
		if self.movingDirection == 1 or self.movingDirection == -1 then
			if self.loweringTime <= 1500 then
				self.loweringTime = self.loweringTime+(0.1*dt);
			end;
		end;
	end;
	if self.loweringTime > 1500 then
		self.loweringTime_boolean = true;
		else
		self.loweringTime_boolean = false;
	end;
	
	if self.buy then
		self.loweringTime = 0;
		self.loweringTime_boolean = false;
		g_currentMission:addSharedMoney(-5000); 
		setVisibility(self.kaputteStuetze, false);
		setVisibility(self.stuetze, true);
		self.buy = false;
	end;
end;

function KLS:draw()
	if self.loweringTime_boolean then
		g_currentMission:addWarning(g_i18n:getText("stuetze_kaufen"));
	end;
	if not self.loweringTime_boolean then
		if not self.stuetzenPosition then
			g_currentMission:addHelpButtonText(g_i18n:getText("stuetze_einfahren"), InputBinding.stuetze);
		end;
		if self.stuetzenPosition then
			g_currentMission:addHelpButtonText(g_i18n:getText("down"), InputBinding.stuetze);
		end;
	end;
end;

function KLS:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function KLattacherVehicleS:onDetach(attacherVehicle)

end;

function KLS:onLeave()
	
end;