SetUnloadSideEvent = {};
SetUnloadSideEvent_mt = Class(SetUnloadSideEvent, Event);

InitEventClass(SetUnloadSideEvent, "SetUnloadSideEvent");

function SetUnloadSideEvent:emptyNew()
    local self = Event:new(SetUnloadSideEvent_mt);
    self.className="SetUnloadSideEvent";
    return self;
end;

function SetUnloadSideEvent:new(vehicle, unloadSide)
    local self = SetUnloadSideEvent:emptyNew()
    self.vehicle = vehicle;
	self.unloadSide = unloadSide;
    return self;
end;

function SetUnloadSideEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.unloadSide = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetUnloadSideEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.unloadSide);	
end;

function SetUnloadSideEvent:run(connection)
	self.vehicle:setUnloadSide(self.unloadSide, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetUnloadSideEvent:new(self.vehicle, self.unloadSide), nil, connection, self.vehicle);
	end;
end;

function SetUnloadSideEvent.sendEvent(vehicle, unloadSide, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetUnloadSideEvent:new(vehicle, unloadSide), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetUnloadSideEvent:new(vehicle, unloadSide));
		end;
	end;
end;

SetLeftDoorEvent = {};
SetLeftDoorEvent_mt = Class(SetLeftDoorEvent, Event);

InitEventClass(SetLeftDoorEvent, "SetLeftDoorEvent");

function SetLeftDoorEvent:emptyNew()
    local self = Event:new(SetLeftDoorEvent_mt);
    self.className="SetLeftDoorEvent";
    return self;
end;

function SetLeftDoorEvent:new(vehicle, isLeftDoor)
    local self = SetLeftDoorEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLeftDoor = isLeftDoor;
    return self;
end;

function SetLeftDoorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLeftDoor = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLeftDoorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLeftDoor);
end;

function SetLeftDoorEvent:run(connection)   
	self.vehicle:setLeftDoor(self.isLeftDoor, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLeftDoorEvent:new(self.vehicle, self.isLeftDoor), nil, connection, self.vehicle);
    end;
end;

function SetLeftDoorEvent.sendEvent(vehicle, isLeftDoor, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLeftDoorEvent:new(vehicle, isLeftDoor), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLeftDoorEvent:new(vehicle, isLeftDoor));
		end;
	end;
end;

SetRightDoorEvent = {};
SetRightDoorEvent_mt = Class(SetRightDoorEvent, Event);

InitEventClass(SetRightDoorEvent, "SetRightDoorEvent");

function SetRightDoorEvent:emptyNew()
    local self = Event:new(SetRightDoorEvent_mt);
    self.className="SetRightDoorEvent";
    return self;
end;

function SetRightDoorEvent:new(vehicle, isRightDoor)
    local self = SetRightDoorEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRightDoor = isRightDoor;
    return self;
end;

function SetRightDoorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRightDoor = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRightDoorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRightDoor);
end;

function SetRightDoorEvent:run(connection)   
	self.vehicle:setRightDoor(self.isRightDoor, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRightDoorEvent:new(self.vehicle, self.isRightDoor), nil, connection, self.vehicle);
    end;
end;

function SetRightDoorEvent.sendEvent(vehicle, isRightDoor, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRightDoorEvent:new(vehicle, isRightDoor), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRightDoorEvent:new(vehicle, isRightDoor));
		end;
	end;
end;

SetFruitTypeEvent = {};
SetFruitTypeEvent_mt = Class(SetFruitTypeEvent, Event);

InitEventClass(SetFruitTypeEvent, "SetFruitTypeEvent");

function SetFruitTypeEvent:emptyNew()
    local self = Event:new(SetFruitTypeEvent_mt);
    self.className="SetFruitTypeEvent";
    return self;
end;

function SetFruitTypeEvent:new(vehicle, fruitType)
    local self = SetFruitTypeEvent:emptyNew()
    self.vehicle = vehicle;
	self.fruitType = fruitType;
    return self;
end;

function SetFruitTypeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fruitType = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetFruitTypeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.fruitType);	
end;

function SetFruitTypeEvent:run(connection)
	self.vehicle:setFruitType(self.fruitType, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetFruitTypeEvent:new(self.vehicle, self.fruitType), nil, connection, self.vehicle);
	end;
end;

function SetFruitTypeEvent.sendEvent(vehicle, fruitType, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFruitTypeEvent:new(vehicle, fruitType), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFruitTypeEvent:new(vehicle, fruitType));
		end;
	end;
end;
