
 ------Kverneland_Exacta_HL_Klappe
 ------Grundscript traillingTruck @author Outlaw
 ------Scriptumbau_daniel11
 
 
klappe = {};
 
function klappe.prerequisitesPresent(specializations)
    return true;
end;


function klappe:load(xmlFile)

   local rotationPartNodeKlappe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKlappe#index"));
    if rotationPartNodeKlappe ~= nil then
        self.rotationPartKlappe = {};
        self.rotationPartKlappe.node = rotationPartNodeKlappe;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKlappe#minRot"));
        self.rotationPartKlappe.minRot = {};
        self.rotationPartKlappe.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKlappe.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKlappe.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKlappe#maxRot"));
        self.rotationPartKlappe.maxRot = {};
        self.rotationPartKlappe.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKlappe.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKlappe.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKlappe.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKlappe#rotTime"), 2)*1000;
        self.rotationPartKlappe.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKlappe#touchRotLimit"), 10));
    end;
	self.rotateKlappe = false;
end;

function klappe:delete()
    
end;

function klappe:mouseEvent(posX, posY, isDown, isUp, button)
    
end;

function klappe:keyEvent(unicode, sym, modifier, isDown)
    
end;

function klappe:update(dt)
	
	if InputBinding.hasEvent(InputBinding.HL_KLAPPE) then
		self.rotateKlappe = not self.rotateKlappe;
	end;
	  
	if self.rotationPartKlappe ~= nil then
        local x, y, z = getRotation(self.rotationPartKlappe.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKlappe.maxRot, self.rotationPartKlappe.minRot, 3, self.rotationPartKlappe.rotTime, dt, not self.rotateKlappe);
		setRotation(self.rotationPartKlappe.node, unpack(newRot));
    end;
	
end;

function klappe:draw()
	if self.rotateKlappe then
		g_currentMission:addHelpButtonText(g_i18n:getText("HL_KLAPPE1"), InputBinding.HL_KLAPPE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("HL_KLAPPE2"), InputBinding.HL_KLAPPE);
	end;
end;