--
-- Kverneland_Exacta_HL
-- Specialization for Kverneland_Exacta_HL
--
-- @author Felix "Outlaw" Sorge
-- @date  27/04/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

Kverneland_Exacta_HL = {};

function Kverneland_Exacta_HL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;


function Kverneland_Exacta_HL:load(xmlFile)

	self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;

	local count = getXMLInt(xmlFile, "vehicle.drums#count");
    self.drums = {}
	local part = self.drums;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.drums.part" .. "%d", i);
	    part[i].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#rot"));
		part[i].rot = {};
	    part[i].rot[1] = Utils.getNoNil(x, 0);
	    part[i].rot[2] = Utils.getNoNil(y, 0);
	    part[i].rot[3] = Utils.getNoNil(z, 0);
		for j=1, 3 do
			if part[i].rot[j] ~= 0 then
				part[i].rot[j] = 1/part[i].rot[j]
			end;
		end;
    end;
	self.literPerHa = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerHa#value"), 1);
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
			
	self.dustParticleSystems2 = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems2#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems2.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems2, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste";	
	if g_settingsJoystickEnabled then 
		self.keySet = not self.keySet;
	end; 	
	
	
	self.moveParticle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.moveParticle#index"));
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	self.AIon = false; 
	
	self.aiLeftMarker12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#LL"));
    self.aiRightMarker12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#RR"));
	self.saveAILM12 = self.aiLeftMarker12;
	self.saveAIRM12 = self.aiRightMarker12;
	
	self.aiLeftMarker6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#L"));
    self.aiRightMarker6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aiExtend#R"));
	self.saveAILM6 = self.aiLeftMarker6;
	self.saveAIRM6 = self.aiRightMarker6;
	
	self.saveAILM = self.aiLeftMarker;
	self.saveAIRM = self.aiRightMarker;
	self.aiRightMarker = nil; 
	self.aiLeftMarker = nil; 
	self.change = 0; 
	self.dy = 6000; 
	self.lewy = true;
	self.prawy = true;
	self.lewa = 0;
	self.prawa = 0;
	self.pow = false;

end;

function Kverneland_Exacta_HL:keyEvent(unicode, sym, modifier, isDown)
	if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Kverneland_Exacta_HL_ON) and self.AIon == false and self.fillLevel > 0 then
		self.turnOn = not self.turnOn; 
	end;
	
	if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Kverneland_Exacta_HL_CHANGE) and self.AIon == false and self.fillLevel > 0 then
		self.change = self.change + 1;  
		if self.change == 3 then
			self.change = 0; 
		end; 	
	end;
	
	if isDown and sym==Input.KEY_8 then
		self.keySet = not self.keySet; 
	end; 	
	
	if isDown and sym == Input.KEY_KP_7 then
		self.lewy = not self.lewy;
	end;
	
	if isDown and sym == Input.KEY_KP_9 then
		self.prawy = not self.prawy;
	end;


end;


function Kverneland_Exacta_HL:update(dt)

	if self.attacherVehicle then
	
		if self.keySet then
			self.keyType = InputBinding.getButtonName;
			self.keyName = "Button"; 
		else
			self.keyType = InputBinding.getButtonKeyName;
			self.keyName = "Taste"; 
		end; 
		
		if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {Utils.degToRad(2),0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;
	
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.AIon = self.attacherVehicle.isAITractorActivated;
		end; 
		
		if self.AIon == false then
			self.AIblock = nil;
		end; 	
			
		if self.delay == true then
	        self.dy = self.dy - dt;
	        if self.dy <= 0 then
	            self.delay = false;
	            self.dy = 6000; 
				self.AIblock = nil; 
	        end;
	    end;
		
		if self.turnOn then
			if self.attacherVehicle.isAITractorActivated ~= nil then
				if self.change == 0 then
					self.aiLeftMarker = self.saveAILM; 
					self.aiRightMarker = self.saveAIRM; 
				end; 
				if self.change == 1 then
					self.aiLeftMarker = self.saveAILM12; 
					self.aiRightMarker = self.saveAIRM12; 
				end; 
				if self.change == 2 then
					self.aiLeftMarker = self.saveAILM6; 
					self.aiRightMarker = self.saveAIRM6; 
				end; 
				AITractor.updateToolsInfo(self.attacherVehicle)
			end; 	
			for i=1, table.getn(self.drums) do
				rotate(self.drums[i].index, self.drums[i].rot[1] / 10 * dt, self.drums[i].rot[2] / 10 * dt, self.drums[i].rot[3] / 10 * dt);
			end;
			
			if self.fillLevel == 0 then
				self.turnOn = not self.turnOn;	
			end; 
			
			if self.AIon and self.AIblock == true then
				Utils.setEmittingState(self.dustParticleSystems, false)
			end; 
			if self.fillLevel > 0 and self.AIblock == nil then
			

				
				if self.change == 0 then
					Utils.setEmittingState(self.dustParticleSystems2, true)
					Utils.setEmittingState(self.dustParticleSystems, false)
					local usage = self.literPerHa*12*0.0000005*(self.lastSpeed*3600);
					self:setFillLevel(self.fillLevel-usage, self.currentFillType);
					if self.lewy then
					local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					self.lewa = 6;
					else
					self.lewa = 0;
					end;
					if self.prawy then
					local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					self.prawa = 6;
					else
					self.prawa = 0;
					end;
	           end; 
			   
			   	if self.change == 1 then
					Utils.setEmittingState(self.dustParticleSystems, true)
					Utils.setEmittingState(self.dustParticleSystems2, false)
					local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local usage = self.literPerHa*(self.lewa+self.prawa)*0.0000005*(self.lastSpeed*3600);
					self:setFillLevel(self.fillLevel-usage, self.currentFillType);
					if self.lewy then
			        local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					self.lewa = 12;
					else
					self.lewa = 0;
					end;
					if self.prawy then
					local x,y,z = getWorldTranslation(self.cuttingAreas[4].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[4].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[4].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					self.prawa = 12;
					else
					self.prawa = 0;
					end;
	           end; 
			   
			   
			   	if self.change == 2 then
					Utils.setEmittingState(self.dustParticleSystems, true)
					Utils.setEmittingState(self.dustParticleSystems2, false)
					local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
					local usage = self.literPerHa*(self.lewa + self.prawa)*0.0000005*(self.lastSpeed*3600);
					self:setFillLevel(self.fillLevel-usage, self.currentFillType);
					if self.lewy then
				    local x,y,z = getWorldTranslation(self.cuttingAreas[5].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[5].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[5].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					self.lewa = 18;
					else
					self.lewa = 0;
					end;
					if self.prawy then
					local x,y,z = getWorldTranslation(self.cuttingAreas[6].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[6].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[6].height);
	                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
					self.prawa = 18;
					else
					self.prawa = 0;
					end;
	           end; 
				
			end;
		else
			Utils.setEmittingState(self.dustParticleSystems, false)
			Utils.setEmittingState(self.dustParticleSystems2, false)
			if self.attacherVehicle.isAITractorActivated ~= nil then
				self.aiLeftMarker = nil; 
				self.aiRightMarker = nil;
				AITractor.updateToolsInfo(self.attacherVehicle)
			end; 	
		end;
		
	end; 
	
	self.powierzchnia = self.fillLevel/self.literPerHa;
	
end;

function Kverneland_Exacta_HL:draw()

	if self.AIon == false then
		if self.fillLevel > 0 then
			if self.turnOn then
				g_currentMission:addHelpButtonText(g_i18n:getText("Kverneland_Exacta_HL_2"), InputBinding.Kverneland_Exacta_HL_ON);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("Kverneland_Exacta_HL_1"), InputBinding.Kverneland_Exacta_HL_ON);
			end; 	
			
			if self.change == 0 then
				g_currentMission:addHelpButtonText(g_i18n:getText("Kverneland_Exacta_HL_3") , InputBinding.Kverneland_Exacta_HL_CHANGE);
			end; 
			if self.change == 1 then
				g_currentMission:addHelpButtonText(g_i18n:getText("Kverneland_Exacta_HL_5"), InputBinding.Kverneland_Exacta_HL_CHANGE);
			end
			if self.change == 2 then
				g_currentMission:addHelpButtonText(g_i18n:getText("Kverneland_Exacta_HL_6"), InputBinding.Kverneland_Exacta_HL_CHANGE);
			end
		end; 
		
		if self.fillLevel == 0 then
			g_currentMission:addExtraPrintText(g_i18n:getText("Kverneland_Exacta_HL_4"));
		end; 
		g_currentMission:addExtraPrintText(string.format("Nawoz na %0.2fha",self.powierzchnia));

	end;

end;


function Kverneland_Exacta_HL:onAttach()
	self.fixAttacher = true; 
end; 	


function Kverneland_Exacta_HL:onDetach()
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
	Utils.setEmittingState(self.dustParticleSystems, false)
end;


function Kverneland_Exacta_HL:delete()
	Utils.setEmittingState(self.dustParticleSystems, false)
	Utils.deleteParticleSystem(self.dustParticleSystems)
end;


function Kverneland_Exacta_HL:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Kverneland_Exacta_HL:aiLower()
	if self.change == 2 then
		self.dy = 2000; 
	end; 
	if self.change == 1 then
		self.dy = 1000; 
	end; 
	self.delay = true;
end; 


function Kverneland_Exacta_HL:aiRaise()
	self.AIblock = true; 
end; 

