GA7822 = {};

function GA7822.prerequisitesPresent(specializations)   
return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;
function GA7822:load(xmlFile)
            print("'lua loaded '" );
self.setCilindroDirection = SpecializationUtil.callSpecializationsFunction("setCilindroDirection");	
	local cilindrosCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cilindros#count"), 0);	
	self.cilindros = {};	
	for i=1, cilindrosCount do
		local cilindroName = string.format("vehicle.cilindros.cilindro%d", i);		
		self.cilindros[i] = {};		
		self.cilindros[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#index"));
		self.cilindros[i].part = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#part"));
		self.cilindros[i].cilindroFixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#cilindroFixpoint"));
		self.cilindros[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, cilindroName .. "#fixpoint"));
		local ax, ay, az = getWorldTranslation(self.cilindros[i].part);
		local bx, by, bz = getWorldTranslation(self.cilindros[i].cilindroFixpoint);		
		self.cilindros[i].partDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;	


 local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;	
	local numRotParts1 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts1#count"), 0);
    self.RotParts1 = {};
    for i=1, numRotParts1 do
      local partnamei = string.format("vehicle.RotParts1.part" .. "%d", i);
      self.RotParts1[i] = {};
      self.RotParts1[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts1[i].minRot = {};
      self.RotParts1[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts1[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts1[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts1[i].maxRot = {};
      self.RotParts1[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts1[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts1[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts1[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;	
	  local windrowerSound = getXMLString(xmlFile, "vehicle.windrowerSound#file");
    if windrowerSound ~= nil and windrowerSound ~= "" then
        windrowerSound = Utils.getFilename(windrowerSound, self.baseDirectory);
        self.windrowerSound = createSample("windrowerSound");
        self.windrowerSoundEnabled = false;
        loadSample(self.windrowerSound, windrowerSound, false);
        self.windrowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#pitchOffset"), 1);
        self.windrowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#volume"), 1.0);
    end;
		 local hidraulicSound = getXMLString(xmlFile, "vehicle.hidraulicSound#file");
    if hidraulicSound ~= nil and hidraulicSound ~= "" then
        hidraulicSound = Utils.getFilename(hidraulicSound, self.baseDirectory); 
        self.hidraulicSound = createSample("hidraulicSound");
        loadSample(self.hidraulicSound, hidraulicSound, false);
        self.hidraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchOffset"), 1);
        self.hidraulicSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchScale"), 0);
        self.hidraulicSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchMax"), 2.0);
    end;
local giroIndexStr = getXMLString(xmlFile, "vehicle.giro#index"); 
 self.giro = Utils.indexToObject(self.components, giroIndexStr);
  
-- self.particleSystems = {};
    -- local i = 0;
    -- while true do
        -- local namei = string.format("vehicle.particleSystems.particleSystems(%d)", i);
		-- local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		-- if nodei == nil then
			-- break;
		-- end; 
        -- Utils.loadParticleSystem(xmlFile, self.particleSystems, namei, nodei, false, nil, self.baseDirectory)		
		-- i = i +1;		
    -- end;
-- self.particleSystems1 = {};
    -- local i = 0;
    -- while true do
        -- local namei = string.format("vehicle.particleSystems1.particleSystems1(%d)", i);
		-- local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		-- if nodei == nil then
			-- break;
		-- end; 
        -- Utils.loadParticleSystem(xmlFile, self.particleSystems1, namei, nodei, false, nil, self.baseDirectory)		
		-- i = i +1;		
    -- end;
	
		self.drumNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index"));
	self.drumNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index2"));
self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
	
  
  self.pie1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pie1#index"));
	self.pie2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pie2#index"));
 self.pie3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pie3#index"));

	local translationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart5#index"));
    if translationPartNode5 ~= nil then
        self.translationPart5 = {};
        self.translationPart5.node = translationPartNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart5#minTrans"));
        self.translationPart5.minTrans = {};
        self.translationPart5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart5#maxTrans"));
        self.translationPart5.maxTrans = {};
        self.translationPart5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart5#transTime"), 2)*1000;
        self.translationPart5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart5#touchTransLimit"), 10);
    end;
	
	
	   local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas ~= 1 or numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;

    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;
		self.groundCheck = {};
	self.groundCheck = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundCheck#index"));
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
       
    end;
	local translationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);
	 self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
     end;
	 self.controlpath = Utils.getFilename("GA7822.jpg", self.baseDirectory);
   
    self.hudGA7822PoxX = 0.01;
    self.hudGA7822PoxY = 1-0.204;
    self.hudGA7822Width = 0.50;
    self.hudGA7822Height = 0.260;
    self.hudGA7822PoxX = 0.45;
    self.hudGA7822PoxY = 0.60
    self.hudGA7822Overlay = Overlay:new("hudGA7822", self.controlpath, self.hudGA7822PoxX, self.hudGA7822PoxY, self.hudGA7822Width, self.hudGA7822Height);
     self.bcActive = false;
 -- self.lastSpeed = 0;
	
setVisibility(self.pie3,false);
end;

function GA7822:delete()
		-- Utils.setEmittingState(self.particleSystems1,false)

  -- Utils.setEmittingState(self.particleSystems, false)
 if self.windrowerSound ~= nil then
        delete(self.windrowerSound);
    end;
end;


function GA7822:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GA7822:keyEvent(unicode, sym, modifier, isDown)
   if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;
if isDown and sym == Input.KEY_v   then
		self.rotParts = not self.rotParts;	
		
	end;
  if isDown and sym == Input.KEY_x   then
		self.rotParts1 = not self.rotParts1;	
		self.translationMax5 = not self.translationMax5 ;
	end;
  if isDown and sym == Input.KEY_b   then
		self.isTurnedOn = not self.isTurnedOn;
	end;
if sym == Input.KEY_KP_3 then
	self.playHidraulic = not self.playHidraulic;
	end;
	if sym == Input.KEY_KP_1 then
self.playHidraulic1 = not self.playHidraulic1;
	end;
	 if isDown and sym == Input.KEY_m then
	self.rotationMax1 = not self.rotationMax1;
	self.translationMax2 = not self.translationMax2 ;
	end;
end;


function GA7822:update(dt)

	
	if self.attacherVehicle then
	
		
	if self.isTurnedOn 		then
	if self.drumNode1 ~= nil then
				rotate(self.drumNode1, self.drumRotationScale * 35 * 0, 0, -10);
			end;	
		if self.drumNode2 ~= nil then
				rotate(self.drumNode2, self.drumRotationScale * 35 * 0, 0, -10);
			end;	
	
	 	local x,y,z = getWorldTranslation(self.groundCheck);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gC = y-terrainHeight; 
		
			if (math.min(gC) < 0.5) then
			self.go = true;
			else
			self.go = false;
			end;	
			
	 if not self.windrowerSoundEnabled and self:getIsActiveForSound() then
                playSample(self.windrowerSound, 0, self.windrowerSoundVolume, 0);
                setSamplePitch(self.windrowerSound, self.windrowerSoundPitchOffset);
                self.windrowerSoundEnabled = true;
            end;
			
	end;	
	  if not self.isTurnedOn and self.windrowerSoundEnabled then
        stopSample(self.windrowerSound);
        self.windrowerSoundEnabled = false;
    end;
	   if self.playHidraulic or self.playHidraulic1 then
      if self.hidraulicSound ~= nil and not self.hidraulicSoundEnabled then
                if self:getIsActiveForSound() then
                    setSamplePitch(self.hidraulicSound, self.hidraulicSoundPitchOffset);
                    playSample(self.hidraulicSound, 0, 0.5, 0);
                    self.hidraulicSoundEnabled = true;
                end;
            end;
     
		
     else
            if self.hidraulicSound ~= nil and self.hidraulicSoundEnabled then
                stopSample(self.hidraulicSound);
                self.hidraulicSoundEnabled = false;
            end;
     
	end;

		
    end;
	if not self.rotParts  and self.go then
	if self.isTurnedOn   and  self.rotParts1 then
        local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    local foldAnimTime = self.foldAnimTime;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[i];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            if not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_GRASS;
                            end;
				
				if  self.rotParts1 then

                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;

                            if area > 0 then
                                fruitTypeFix = true;
                            end;

                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[i];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
										-- Utils.setEmittingState(self.particleSystems, true)
                                    end;
								end;
							end;
						end;
					end;
                end;
			end;
			end;
	
	
		local giroRotationSpeed = 0.0005;
        local giroMinRotZ = -32*3.1415/180.0;
		local giroMaxRotZ = 45*3.1415/180.0;
		
 
 
  if self.giro ~= nil then
            local x,y,z = getRotation(self.giro);
        if Input.isKeyPressed(Input.KEY_KP_2) then
		z = 0;
		end;
            if Input.isKeyPressed(Input.KEY_KP_3) then
                z = z-dt*giroRotationSpeed;
            elseif Input.isKeyPressed(Input.KEY_KP_1) then
                z = z+dt*giroRotationSpeed;
            end;
			if z < giroMinRotZ then
                z = giroMinRotZ;
            end;
			if z > giroMaxRotZ then
                z = giroMaxRotZ;
            end;
 
   setRotation(self.giro, x, y, z);
 
 end;
 
	if self.translationMax5 ~= nil then
		local x, y, z = getTranslation(self.translationPart5.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart5.maxTrans, self.translationPart5.minTrans, 3, self.translationPart5.transTime, dt, not self.translationMax5);
        setTranslation(self.translationPart5.node, unpack(newTrans));
		end;
	
		if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
				end;
		if self.rotParts1 ~= nil   then
				for i=1, table.getn(self.RotParts1) do
					local rot = {getRotation(self.RotParts1[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts1[i].maxRot, self.RotParts1[i].minRot, 3, self.RotParts1[i].rotTime, dt, not self.rotParts1);
					setRotation(self.RotParts1[i].index, unpack(newRot));
				end;
				end;
			if self.rotationMax1 ~= nil then
        local x, y, z = getRotation(self.rotationPart1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
        setRotation(self.rotationPart1.node, unpack(newRot));
    end;		
	if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
		end;	
	
	local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);	
	local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[7];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);		
	local joint = self.componentJoints[8];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[9];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);	
		local joint = self.componentJoints[10];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[11];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);	
	local joint = self.componentJoints[12];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[13];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);		
	self:setCilindroDirection();
end;
function GA7822:draw()
	 if self.hudGA7822Overlay ~= nil then
  if self.bcActive then
    self.hudGA7822Overlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("play 0: menu On");
		else
			g_currentMission:addExtraPrintText("play 0: menu Off");
		end;
end;
function GA7822:onAttach()	
setVisibility(self.pie1,false);
setVisibility(self.pie2,false);
setVisibility(self.pie3,true);
end;

function GA7822:onDetach()
  self.isTurnedOn = false;
setVisibility(self.pie1,true);
setVisibility(self.pie2,true);
setVisibility(self.pie3,false);
	stopSample(self.windrowerSound);
    self.windrowerSoundEnabled = false;
	
end;
function GA7822:setCilindroDirection()
	for i=1, table.getn(self.cilindros) do
		local ax, ay, az = getWorldTranslation(self.cilindros[i].node);
		local bx, by, bz = getWorldTranslation(self.cilindros[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.cilindros[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.cilindros[i].node, x, y, z, 0, 1, 0);
		if self.cilindros[i].part ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.cilindros[i].part,0 ,0 ,distance-self.cilindros[i].partDistance);
		end;	
	end;
end;




