--
-- Name: Swather
-- Description: Specialization for swathing on mowers
-- Version: 1.0
-- Author: Saracaen
-- Date: 22/10/2011
--

source("dataS/scripts/vehicles/specializations/WindrowAreaEvent.lua");

Swather = {};

function Swather.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(EnhancedMower, specializations);
end;

function Swather:load(xmlFile)

	-- Cutting areas --
	self.accumulatedCuttingAreaValues = {};
	local i = 0;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	for i = 1, numCuttingAreas do
		self.accumulatedCuttingAreaValues[i] = 0;
	end;
	
	-- Swathing areas --
	self.swathingAreas = {};
	local i = 0;
	local numSwathingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.swathingAreas#count"), 0);
	for i = 1, numSwathingAreas do
		self.swathingAreas[i] = {};
		local baseName = string.format("vehicle.swathingAreas.swathingArea%d", i);
		self.swathingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#startIndex"));
		self.swathingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#widthIndex"));
		self.swathingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#heightIndex"));
	end;

end;

function Swather:delete()
end;

function Swather:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Swather:keyEvent(unicode, sym, modifier, isDown)
end;

function Swather:update(dt)
end;

function Swather:updateTick(dt)
	if self:getIsActive() then
	
		if self.isServer then
		
			-- Cutting areas --
			if self.isTurnedOn and (self.isDown or self:isLowered(false)) then
				local x,y,z = getWorldTranslation(self.groundReferenceNode);
				local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				
				if terrainHeight + self.groundReferenceThreshold >= y and self.attacherVehicle.movingDirection > 0.001 then
					local cuttingAreasSend = {};
					local swathingAreasSend = {};
					
					for k, cuttingArea in pairs(self.cuttingAreas) do
						if self:getIsAreaActive(cuttingArea) then
							local x,y,z = getWorldTranslation(cuttingArea.start);
							local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
							local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							
							table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
						end;
					end;
					
					for k, swathingArea in pairs(self.swathingAreas) do
						local dx,dy,dz = getWorldTranslation(swathingArea.start);
						local dx1,dy1,dz1 = getWorldTranslation(swathingArea.width);
						local dx2,dy2,dz2 = getWorldTranslation(swathingArea.height);
						
						table.insert(swathingAreasSend, {dx,dz,dx1,dz1,dx2,dz2});
					end;
					
					if table.getn(cuttingAreasSend) > 0 then
						-- Clamp the accumulated values to prevent it from creating swaths
						for k, v in pairs(self.accumulatedCuttingAreaValues) do
							self.accumulatedCuttingAreaValues[k] = math.min(v, g_currentMission.windrowCutLongRatio);
						end;
					
						local cuttingAreasSend, swathingAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(cuttingAreasSend, swathingAreasSend, self.accumulatedCuttingAreaValues);
						
						if table.getn(cuttingAreasSend) > 0 then
							g_server:broadcastEvent(WindrowAreaEvent:new(cuttingAreasSend, swathingAreasSend, fruitType, bitType));
						end;
					end;
				end;
			end;
		
		end;
	
	end;
end;

function Swather:draw()
end;