--
-- Name: SetArmExpandedEvent
-- Description: Set arm expanded event for the Kuhn GMD 4010 mower
-- Version: 1.0
-- Author: Saracaen
-- Date: 21/10/2011
--

SetArmExpandedEvent = {};
SetArmExpandedEvent_mt = Class(SetArmExpandedEvent, Event);

InitEventClass(SetArmExpandedEvent, "SetArmExpandedEvent");

function SetArmExpandedEvent:emptyNew()
	local self = Event:new(SetArmExpandedEvent_mt);
	self.className="SetArmExpandedEvent";
	return self;
end;

function SetArmExpandedEvent:new(object, isArmExpanded)
	local self = SetArmExpandedEvent:emptyNew()
	self.object = object;
	self.isArmExpanded = isArmExpanded
	return self;
end;

function SetArmExpandedEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isArmExpanded = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SetArmExpandedEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isArmExpanded);
end;

function SetArmExpandedEvent:run(connection)
	self.object:setIsArmExpanded(self.isArmExpanded, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetArmExpandedEvent:new(self.object, self.isArmExpanded), nil, connection, self.object);
	end;
end;

function SetArmExpandedEvent.sendEvent(vehicle, isArmExpanded, noEventSend)
	if isArmExpanded ~= vehicle.arm.isExpanded then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetArmExpandedEvent:new(vehicle, isArmExpanded), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetArmExpandedEvent:new(vehicle, isArmExpanded));
			end;
		end;
	end;
end;