--
-- Name: SetArmDownEvent
-- Description: Set arm down event for the Kuhn GMD 4010 mower
-- Version: 1.0
-- Author: Saracaen
-- Date: 21/10/2011
--

SetArmDownEvent = {};
SetArmDownEvent_mt = Class(SetArmDownEvent, Event);

InitEventClass(SetArmDownEvent, "SetArmDownEvent");

function SetArmDownEvent:emptyNew()
	local self = Event:new(SetArmDownEvent_mt);
	self.className="SetArmDownEvent";
	return self;
end;

function SetArmDownEvent:new(object, isArmDown)
	local self = SetArmDownEvent:emptyNew()
	self.object = object;
	self.isArmDown = isArmDown
	return self;
end;

function SetArmDownEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isArmDown = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SetArmDownEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isArmDown);
end;

function SetArmDownEvent:run(connection)
	self.object:setIsArmDown(self.isArmDown, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetArmDownEvent:new(self.object, self.isArmDown), nil, connection, self.object);
	end;
end;

function SetArmDownEvent.sendEvent(vehicle, isArmDown, noEventSend)
	if isArmDown ~= vehicle.arm.isDown then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetArmDownEvent:new(vehicle, isArmDown), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetArmDownEvent:new(vehicle, isArmDown));
			end;
		end;
	end;
end;