--
-- setJointLimits
-- to fix componentJoints when liftet
-- um componentJoints beim anheben zu fixieren
-- @author  Sven777b
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.
--
-- Hinweis: das kopieren von Sourcecode ist strafbar nach UrhG 2.1
--
-- XML: <setJointLimit componentJoint="1" anchorActor="1" time="3" />
-- Moddesc: <specialization name="setJointLimits" className="setJointLimits" filename="setJointLimits.lua"/>

setJointLimits = {};

function setJointLimits.prerequisitesPresent(specializations)
    return true;
end;

function setJointLimits:load(xmlFile)
	local componentJointI = 0;
	local joint = getXMLInt(xmlFile, "vehicle.setJointLimit#componentJoint");
	if joint ~= nil then
		self.anchor = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.setJointLimit#anchorActor"),0);
		self.movetime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.setJointLimit#time"),1)*1000;
		local key = string.format("vehicle.components.joint(%d)", joint-1);
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  key.."#rotLimit"));
		local rotLimits = {};
		rotLimits[1] = math.rad(Utils.getNoNil(x, 0));
		rotLimits[2] = math.rad(Utils.getNoNil(y, 0));
		rotLimits[3] = math.rad(Utils.getNoNil(z, 0));
		self.maxJointLimits = rotLimits;
		self.minJointLimits = {0,0,0};
		self.curJointLimits = rotLimits;
		self.jointNr = joint;
	end;
end;

function setJointLimits:delete()
end;

function setJointLimits:mouseEvent(posX, posY, isDown, isUp, button)
end;

function setJointLimits:keyEvent(unicode, sym, modifier, isDown)
end;

function setJointLimits:update(dt)
	if self:getIsActive() then
	    if self.attacherVehicle ~= nil and self.jointNr ~= nil then
			local impind = self.attacherVehicle:getImplementIndexByObject(self);
			local jointDescIndex = self.attacherVehicle.attachedImplements[impind].jointDescIndex;
			local jointDesc = self.attacherVehicle.attacherJoints[jointDescIndex];
			
			local newLimits = Utils.getMovedLimitedValues(self.curJointLimits, self.maxJointLimits, self.minJointLimits, 3, self.movetime, dt, not jointDesc.moveDown);
			for i=1, 3 do
				if math.abs(newLimits[i] - self.curJointLimits[i]) > 0.0005 then
					setJointRotationLimit(self.componentJoints[self.jointNr].jointIndex, (i-1), true, math.abs(newLimits[i])*-1 , math.abs(newLimits[i]));
					setJointFrame(self.componentJoints[self.jointNr].jointIndex, self.anchor, self.componentJoints[self.jointNr].jointNode);
				end;
			end;
			self.curJointLimits = newLimits;
		end;
	end;
end;

function setJointLimits:updateTick(dt)
end;

function setJointLimits:draw()
end;

	