--
-- NewDetach
-- Desc
--
-- @author 	FIAT80-90DT
-- @date  	04.01.2012
--
-- www.modding-stage.com

NewDetach = {};

function NewDetach.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function NewDetach:load(xmlFile)
	self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
	
	self.warning = 0;
end;

function NewDetach:delete()
end;

function NewDetach:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NewDetach:keyEvent(unicode, sym, modifier, isDown)
end;

function NewDetach:update(dt)
	if self:getIsActiveForInput() then
		local x,y,z = getWorldTranslation(self.groundReferenceNode);
		local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		
		if terrainHeight+self.groundReferenceThreshold >= y then
			self.allowsDetaching = true;
		else
			self.allowsDetaching = false;
			if InputBinding.hasEvent(InputBinding.ATTACH) and g_currentMission.attachableInMountRange == nil then
				self.warning = self.time + 750;
			end;
		end;
	end;
end;

function NewDetach:draw()
	if self.allowsDetaching and g_currentMission.attachableInMountRange == nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("DETACH"), InputBinding.ATTACH);
	else
		if self.warning > self.time then
			g_currentMission:addExtraPrintText(g_i18n:getText("DETACH_ERROR"));	
		end;
	end;
end;
