zhatka = {};

source("dataS/scripts/vehicles/specializations/Cutter.lua");

function zhatka.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function zhatka:load(xmlFile)
	self.myKnivesNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myKnives#index"));
    self.myRollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myRoll#index"));

	self.myRollSpeed = 0;
	self.myKnivesMaxDisplacement = 0.04;
	self.myKnivesMinDisplacement = -0.04;
	self.myKnivesDisplacement = 0.005;

end;

function zhatka:delete()
end;

function zhatka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function zhatka:keyEvent(unicode, sym, modifier, isDown)
end;

function zhatka:update(dt)

			if self.reelStarted then
	self.myRollSpeed = 10;
			else
	self.myRollSpeed = 0;
		end;
		

end;

function zhatka:updateTick(dt)

					if self.myRollNode ~= nil then
					rotate(self.myRollNode, self.myRollSpeed, 0, 0);
				end;

if self.myKnivesNode ~= nil then
					local x,y,z = getTranslation(self.myKnivesNode);
					local displacement = x;
					if displacement >= self.myKnivesMaxDisplacement then
						self.knivesDirection = false;
					elseif displacement <= self.myKnivesMinDisplacement then
						self.knivesDirection = true;
					end;
					
					if self.knivesDirection then
						displacement = x-(self.myKnivesDisplacement * self.myRollSpeed*-1);
					else
						displacement = x+(self.myKnivesDisplacement * self.myRollSpeed*-1);
					end;
					--renderText(0.5, 0.9, 0.040, displacement);
					
					setTranslation(self.myKnivesNode, displacement,y,z)
				end;

end;

function zhatka:draw()
end;

function zhatka:onDetach()
end;

function zhatka:onLeave()
end;