--
-- shkiv
-- This is the specialization for combines
--
-- @author  Stefan Geiger
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

shkiv = {};

function shkiv.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function shkiv:load(xmlFile)
	local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;

    self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));

    self.pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));

    self.rotorFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan#index"));

    self.forog1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog1#index"));
    self.forog2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog2#index"));
    self.forog3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog3#index"));
    self.forog4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog4#index"));
    self.forog5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog5#index"));
    self.forog6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog6#index"));
    self.forog7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog7#index"));
    self.forog8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog8#index"));
    self.forog9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog9#index"));
    self.forog10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog10#index"));
    self.forog11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog11#index"));
    
   local kiptetNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kiptet#index"));
    if kiptetNode ~= nil then
        self.kiptet = {};
        self.kiptet.node = kiptetNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kiptet#minRot"));
        self.kiptet.minRot = {};
        self.kiptet.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kiptet.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kiptet.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kiptet#maxRot"));
        self.kiptet.maxRot = {};
        self.kiptet.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kiptet.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kiptet.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.kiptet.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kiptet#rotTime"), 2)*1000;
        self.kiptet.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kiptet#touchRotLimit"), 10));
    end;
    
    numparts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts#count"), 0);
	self.parts = {};
    for i=1, numparts do
        local partnamei = string.format("vehicle.parts.part%d", i);
        self.parts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts[i], false);
    end;
	self.partsActive = true;
	
	numparts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts2#count"), 0);
	self.parts2 = {};
    for i=1, numparts2 do
        local partnamei = string.format("vehicle.parts2.part%d", i);
        self.parts2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts2[i], false);
    end;
	self.parts2Active = true;
	
	self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));
	self.pipeLight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight1#index"));	
	self.pipeLight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight2#index"));
	self.pipeLight3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight3#index"));	
	self.workLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLight#index"));
	self.workLight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLight2#index"));
    self.workLightActive = false;
    self.workLight2Active = false;
    self.pipeLightActive = false;
    self.pipeLight1Active = false;	
    self.pipeLight2Active = false;
    self.pipeLight3Active = false;	
    
end;

function shkiv:delete()
end;

function shkiv:mouseEvent(posX, posY, isDown, isUp, button)
end;

function shkiv:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
	 if isDown and sym == Input.KEY_k then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end; 
	if isDown and sym == Input.KEY_n then 
	  self.partsActive = not self.partsActive;
	end;
	if isDown and sym == Input.KEY_m then 
		self.parts2Active = not self.parts2Active;
	end;
	if isDown and sym == Input.KEY_j then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_n then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
        	if isDown and sym == Input.KEY_n then 
		self.rotationMaxhidra3 = not self.rotationMaxhidra3;
        end;
	if sym == Input.KEY_pagedown then
		self.attachMax = isDown;
	end;
	if sym == Input.KEY_pageup then
		self.attachMin = isDown;
	end;
	
	if isDown and sym == Input.KEY_t then
		self.workLightActive = not self.workLightActive;
		self.workLight2Active = not self.workLight2Active;
	end;
	if isDown and sym == Input.KEY_u then
		self.pipeLightActive = not self.pipeLightActive;
		self.pipeLight1Active = not self.pipeLight1Active;		
	end;
	if isDown and sym == Input.KEY_y then
		self.pipeLight2Active = not self.pipeLight2Active;
		self.pipeLight3Active = not self.pipeLight3Active;		
	end;
end;

function shkiv:update(dt)
  
  if self.partsActive then
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive);
		end;
	        else
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive, false);
	    end;
	end;
   if self.parts2Active then
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active);
		end;
	        else
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active, false);
	    end;	
    end;
    if self.motor.lastMotorRpm > 750 and self.isEntered then

	    if self.kiptet ~= nil then
            local x, y, z = getRotation(self.kiptet.node);
            local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.kiptet.maxRot, self.kiptet.minRot, 3, self.kiptet.rotTime, dt, self.isEntered);
            setRotation(self.kiptet.node, unpack(newRot));
        end;
        
	    if self.motor.lastMotorRpm > 1300 then
	
	       else
	
	    end;
		
         elseif self.isEntered then
	         self.kiptetmove = math.random(300,1300);
	    if self.kiptet ~= nil then
        	local x, y, z = getRotation(self.kiptet.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, {0,0,180}, {0,0,self.kiptetmove*0.001}, 3, 60000, dt, self.isEntered);
        	setRotation(self.kiptet.node, unpack(newRot));
    	end;
        
          else
	    if self.isAITractorActivated then
		    if self.kiptet ~= nil then
        		local x, y, z = getRotation(self.kiptet.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.kiptet.maxRot, self.kiptet.minRot, 3, self.kiptet.rotTime, dt, true);
        		setRotation(self.kiptet.node, unpack(newRot));
    		end;
		
	           else
		    if self.kiptet ~= nil then
        		local x, y, z = getRotation(self.kiptet.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.kiptet.maxRot, self.kiptet.minRot, 3, self.kiptet.rotTime, dt, false);
        		setRotation(self.kiptet.node, unpack(newRot));
    		end;
	    end;
    end;
    

        if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;

    if self:getIsActive() then
        if self.workLight ~= nil then
            if self.workLightActive then
            	setVisibility(self.workLight, self.workLightActive);
	            else
            	setVisibility(self.workLight, self.workLightActive);
	        end;
        end;
        if self.workLight2 ~= nil then
            if self.workLight2Active then
            	setVisibility(self.workLight2, self.workLight2Active);
	            else
            	setVisibility(self.workLight2, self.workLight2Active);
	        end;
        end;
        if self.pipeLight ~= nil then
            if self.pipeLightActive then
            	setVisibility(self.pipeLight, self.pipeLightActive);
	        else
            	setVisibility(self.pipeLight, self.pipeLightActive);
	        end;
        end;
        if self.pipeLight1 ~= nil then
            if self.pipeLight1Active then
            	setVisibility(self.pipeLight1, self.pipeLight1Active);
	        else
            	setVisibility(self.pipeLight1, self.pipeLight1Active);
	        end;
        end;		
        if self.pipeLight2 ~= nil then
            if self.pipeLight2Active then
            	setVisibility(self.pipeLight2, self.pipeLight2Active);
	            else
            	setVisibility(self.pipeLight2, self.pipeLight2Active);
	        end;
        end;
        if self.pipeLight3 ~= nil then
            if self.pipeLight3Active then
            	setVisibility(self.pipeLight3, self.pipeLight3Active);
	        else
            	setVisibility(self.pipeLight3, self.pipeLight3Active);
	        end;
        end;		
        
    
                rotate(self.forog1, 0, 0, dt*-0.01 );
        		rotate(self.forog2, dt*-0.005, 0, 0 );
        
        
        rotate(self.rotorFan, 0, 0, dt*-0.01);
        if self.isThreshingStarted then
            if self.playThreshingSound then
                if self:getIsActiveForSound() then
                    if self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
                        playSample(self.threshingSound, 0, 1, 0);
                        self.playThreshingSound = false;
                        self.threshingSoundActive = true;
                    end;
                end;
            end;
        end;

		if self.isThreshing then
		        
        		rotate(self.forog3, 0, 0, dt*0.01 );
        		rotate(self.forog4, dt*-0.01, 0, 0 );
        		rotate(self.forog5, dt*-0.01, 0, 0 );
        		rotate(self.forog6, dt*0.01, 0, 0 );
        		rotate(self.forog7, 0, 0, dt*-0.012 );
        		rotate(self.forog8, 0, 0, dt*0.01 );
        		rotate(self.forog9, dt*0.01, 0, 0 );
        		rotate(self.forog10, dt*-0.01, 0, 0 );
        		rotate(self.forog11, dt*-0.01, 0, 0 );
			    
		end;

    end;


end;

function shkiv:draw()
    if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.19, 0.02, "");
		else
			renderText(0.8335, 0.19, 0.02, "");
		end;
		if self.helpPanel then
			renderText(0.72, 0.84, 0.025, "");
			renderText(0.72, 0.815, 0.02, "");	
			renderText(0.72, 0.8, 0.02, "");			
			renderText(0.72, 0.785, 0.02, "");
			renderText(0.72, 0.77, 0.02, "");
			renderText(0.72, 0.755, 0.02, "");			
			renderText(0.72, 0.74, 0.02, "");
			renderText(0.72, 0.725, 0.02, "");
			renderText(0.72, 0.71, 0.02, "");

		end;
	end;
end;

function shkiv:onEnter()
end;

function shkiv:onLeave()
    self.workLightActive = false;
    self.workLight2Active = false;
    self.pipeLightActive = false;
    self.pipeLight1Active = false;	
    self.pipeLight2Active = false;
    self.pipeLight3Active = false;	
    setVisibility(self.workLight, self.workLightActive);
    setVisibility(self.workLight2, self.workLight2Active);
    setVisibility(self.pipeLight, self.pipeLightActive);
    setVisibility(self.pipeLight1, self.pipeLight1Active);	
    setVisibility(self.pipeLight2, self.pipeLight2Active);
    setVisibility(self.pipeLight3, self.pipeLight3Active);	

end;


