--
-- powerShift
-- Specialization for power shift with speeder and throttle handle on steerables
--
-- @author  Knagsted
-- @date  15/03/10
--

-- Do not edit without my permission
--

powerShift = {};

function powerShift.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function powerShift:load(xmlFile)
	self.powerShiftEnabled = SpecializationUtil.callSpecializationsFunction("powerShiftEnabled");
	self.gearleaverAnimation = SpecializationUtil.callSpecializationsFunction("gearleaverAnimation");
	self.gearUpForward = SpecializationUtil.callSpecializationsFunction("gearUpForward");
	self.gearDownForward = SpecializationUtil.callSpecializationsFunction("gearDownForward");
	self.gearForwardToNeutral = SpecializationUtil.callSpecializationsFunction("gearForwardToNeutral");
	self.gearUpReverse = SpecializationUtil.callSpecializationsFunction("gearUpReverse");
	self.gearDownReverse = SpecializationUtil.callSpecializationsFunction("gearDownReverse");
	self.gearReverseToNeutral = SpecializationUtil.callSpecializationsFunction("gearReverseToNeutral");

	self.gearUpDva = SpecializationUtil.callSpecializationsFunction("gearUpDva");
	self.gearUpTri = SpecializationUtil.callSpecializationsFunction("gearUpTri");
	
	self.clutchAnimation = SpecializationUtil.callSpecializationsFunction("clutchAnimation");
	self.brakeAnimation = SpecializationUtil.callSpecializationsFunction("brakeAnimation");
	self.speederAnimation = SpecializationUtil.callSpecializationsFunction("speederAnimation");
	
	self.backupMinRpmManual = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
	self.handThrottleEnabled = false;
	
	-- Backup maxRpm
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	
	--ExhaustParticles
	self.extraExhaustParticleSystems = {};
    local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraExhaustParticleSystems#count"), 0);
    for i=1, exhaustParticleSystemCount do
        local namei = string.format("vehicle.extraExhaustParticleSystems.extraExhaustParticleSystem%d", i);
        Utils.loadParticleSystem(xmlFile, self.extraExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
    end;
	
	--animation parts
	self.gearLeaver = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearLeaver#index"));
	self.throttleLeaver = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.throttleLeaver#index"));
	self.speeder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.speeder#index"));
	self.clutch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.clutch#index"));
	self.brake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brake#index"));
	
	--Sounds
	GearShiftSoundFile = Utils.getFilename("gearShift.wav", self.baseDirectory);
    self.GearShiftSoundId = createSample("GearShiftSound");
    loadSample(self.GearShiftSoundId, GearShiftSoundFile, false);
    self.GearShiftPlaying = false;
	
	self.gearShiftSound = false;
	
    -- Percentage of full throttle
    self.throttlePercentage = self.backupMinRpmManual/self.motorMaxRpmLimit[3];
	self.currentGear = 0;
	self.noOfForwardGears = 3;
	self.noOfBackwardGears = 1;
	self.rewUpTime = 1500;
	self.rewUpTimeOffSet = 0;
	self.orgMotorSoundRunPitchMax = self.motorSoundRunPitchMax;
	self.orgMotorSoundPitchMax = self.motorSoundPitchMax;
	self.lastAcceleration = 0;
	self.lastGear = 0;
	self.automaticGearBoxMode = 0;
	self.enabledPowershiftGearBox = false;
	self.backupBrakeForce = self.motor.brakeForce;
	self.powerShiftMinRpm = 850;
	self.rpmMeterValue = 0;
	self.handbrakeOn = false;
	self.hudEnabled = true;
	self.lastGearShiftMode = 0;
	self.motor.backwardBackupGearRatio = self.motor.backwardGearRatio;
	self.motor.forwardBackupGearRatios = self.motor.forwardGearRatios;
end;

function powerShift:delete()
	Utils.deleteParticleSystem(self.extraExhaustParticleSystems);
	if self.GearShiftPlaying ~= nil then
		stopSample(self.GearShiftSoundId);
	end;
end;

function powerShift:mouseEvent(posX, posY, isDown, isUp, button)
end;

function powerShift:keyEvent(unicode, sym, modifier, isDown)
end;

function powerShift:update(dt)
	--if not self.backupsSet then
		--self.backupForwardGearRatio = self.forwardGearRatios;
		--self.backupBackwardGearRatio = self.backwardGearRatio;
		--self.backupsSet = true;
	--end;
	
    if self.isEntered then
	    -- Handle input
        if self:getIsActiveForInput() then
		    -- Raise and lower the throttle percentage
            if InputBinding.isPressed(InputBinding.MORERPM) and self.throttlePercentage < 1 then
		        self.throttlePercentage = self.throttlePercentage + 0.001; 
		    	self.handThrottleEnabled = true;
		    elseif InputBinding.isPressed(InputBinding.LESSRPM) and self.throttlePercentage > self.backupMinRpmManual/self.motorMaxRpmLimit[3] then 
		        self.throttlePercentage = self.throttlePercentage - 0.001; 
			    self.handThrottleEnabled = true;
	        end;
		
	    	-- Disable hand throttle
		    if InputBinding.hasEvent(InputBinding.RESETRPM) then
		        self.handThrottleEnabled = false;
				self.motor.minRpm = self.backupMinRpmManual;
				self.throttlePercentage = self.backupMinRpmManual/self.motorMaxRpmLimit[3];
		    end;
			
			if InputBinding.hasEvent(InputBinding.GEARUP) then
				if not self.automaticGearbox then
					self.currentGear = self.currentGear + 1;
					if self.currentGear > self.noOfForwardGears then
						self.currentGear = self.noOfForwardGears;
					end;
				else
					self.automaticGearBoxMode = self.automaticGearBoxMode + 1;
					if self.automaticGearBoxMode > 1 then
						self.automaticGearBoxMode = 1;
					end;
				end;
		    end;
			
			if InputBinding.hasEvent(InputBinding.GEARDOWN) then
				if not self.automaticGearbox then
					self.currentGear = self.currentGear - 1;
					if self.currentGear < -self.noOfBackwardGears then
						self.currentGear = -self.noOfBackwardGears;
					end;
				else
					self.automaticGearBoxMode = self.automaticGearBoxMode - 1;
					if self.automaticGearBoxMode < -1 then
						self.automaticGearBoxMode = -1;
					end;
				end;
		    end;
			
			if InputBinding.hasEvent(InputBinding.NEUTRAL) then
				self.currentGear = 0;
		    end;
			
			if InputBinding.hasEvent(InputBinding.SWITCHGEARBOXTYPE) then
				self.automaticGearbox = not self.automaticGearbox;
		    end;
			
			if InputBinding.hasEvent(InputBinding.DISABLEPOWERSHIFTGB) then
				if not self.isAITractorActivated and not self.isAutopilotActivated then
					self.enabledPowershiftGearBox = not self.enabledPowershiftGearBox;
				end;
		    end;
			
			if InputBinding.hasEvent(InputBinding.HANDBRAKE) then
				self.handbrakeOn = not self.handbrakeOn;
		    end;
			
			if InputBinding.hasEvent(InputBinding.MAGNUMHUD) then
				self.hudEnabled = not self.hudEnabled;
		    end;
        end;
	end;
		
	--Do powershift gearbox
	if self.enabledPowershiftGearBox and not self.isAITractorActivated and not self.isAutopilotActivated then
		self.motor.minRpm = self.backupMinRpmManual;
		self:powerShiftEnabled(dt);
	else
	--dont do powershift gearbox do normal gearbox with handthrottle and RPM limiter
		self.motor.backwardGearRatio = self.motor.backwardBackupGearRatio;
		self.motor.forwardGearRatios = self.motor.forwardBackupGearRatios;
		
		self.motor.brakeForce = self.backupBrakeForce;
		        -- Local variables
	    local alpha = 1;
	    local roundPerMinute = self.lastRoundPerMinute*alpha + (1-alpha)*(self.motor.lastMotorRpm-self.motor.minRpm);
        local rpmDiff = math.abs(roundPerMinute - ((self.motorMaxRpmLimit[3] * 0.9) * self.throttlePercentage));
		
		if self.handThrottleEnabled then
			-- Lower and raise minRpm with a 100 RPM margin
			if roundPerMinute < ((self.motorMaxRpmLimit[3] * self.throttlePercentage) - 50) then
				self.motor.minRpm = self.motor.minRpm - (rpmDiff / 10);
			elseif roundPerMinute > ((self.motorMaxRpmLimit[3] * self.throttlePercentage) + 50) then
				if self.motor.minRpm <= (self.backupMinRpmManual - (rpmDiff/10)) then
					self.motor.minRpm = self.motor.minRpm + (rpmDiff / 10);
				end;
			end;
		end;
		self.rpmMeterValue = self.motor.lastMotorRpm;
		
		if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
			if self.motor.speedLevel ~= 0 then
				if InputBinding.isPressed(InputBinding.ACCELERATE) then
					if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
						self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
					end;
				elseif InputBinding.isPressed(InputBinding.DECELERATE) then
					if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
						self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
					end;
				end;
			else
				if InputBinding.isPressed(InputBinding.ACCELERATE) then
					if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
						self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
					end;
				elseif InputBinding.isPressed(InputBinding.DECELERATE) then
					if self.motor.maxRpm[3] >= 10 then
						self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
					end;
				end;	
			end;
		end;
	end;

end;

function powerShift:stopMotor()
    self.motor.minRpm = self.backupMinRpmManual;
	self.lastAcceleration = 0;
end;
	
function powerShift:onLeave()
    self.motor.minRpm = self.backupMinRpmManual;
	self.lastAcceleration = 0;
end;

function powerShift:draw()
	if not self.isAITractorActivated and not self.isAutopilotActivated then
		if self.isMotorStarted and not self.enabledPowershiftGearBox then
			g_currentMission:addExtraPrintText(string.format("Taste %s: Reactivieren Powershift transmision", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DISABLEPOWERSHIFTGB)));
		else
			g_currentMission:addExtraPrintText(string.format("Taste %s: Deactivieren Powershift transmision", InputBinding.getKeyNamesOfDigitalAction(InputBinding.DISABLEPOWERSHIFTGB)));
		end;
	end;
	if 	self.hudEnabled then
		if self.enabledPowershiftGearBox and not self.isAITractorActivated and not self.isAutopilotActivated then
			renderText(0.78, 0.52, 0.020, string.format("Gear[PageUp/PageDown]: " .. "%d", self.currentGear));
			if not self.handbrakeOn then
				renderText(0.78, 0.54, 0.020, string.format("Pull Handbrake[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.HANDBRAKE)));
			else
				renderText(0.78, 0.54, 0.020, string.format("Loosen Handbrake[%s]",InputBinding.getKeyNamesOfDigitalAction(InputBinding.HANDBRAKE)));
			end;
		else
			if self.motor.speedLevel ~= 0 then
				renderText(0.78, 0.52, 0.020, string.format("RPM[%s/%s]: %d", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACCELERATE), InputBinding.getKeyNamesOfDigitalAction(InputBinding.DECELERATE), self.motor.maxRpm[self.motor.speedLevel]));
			else
				renderText(0.78, 0.52, 0.020, string.format("RPM[%s/%s]: %d", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACCELERATE), InputBinding.getKeyNamesOfDigitalAction(InputBinding.DECELERATE), self.motor.maxRpm[3]));
			end;
		end;
	end;
end;

function powerShift:powerShiftEnabled(dt)
	if self.isEntered then
		self.gearRatio = 0;
		local ratio = 0;
		if self.currentGear == 1 then
			--self.gearRatio = 0.25;
			self.gearRatio = 0.05;
			ratio = 16;
		elseif self.currentGear == 2 then
			--self.gearRatio = 5;
			self.gearRatio = 0.55;
			ratio = 7;
		elseif self.currentGear == 3 then
			--self.gearRatio = 13;
			self.gearRatio = 1;
			ratio = 4.1;
		elseif self.currentGear == 4 then
			--self.gearRatio = 0.85;
			self.gearRatio = 0.08;
			ratio = 13;
		elseif self.currentGear == 5 then
			--self.gearRatio = 1.05;
			self.gearRatio = 0.1;
			ratio = 11;
		elseif self.currentGear == 6 then
			--self.gearRatio = 1.3;
			self.gearRatio = 0.2;
			ratio = 10;
		elseif self.currentGear == 7 then
			--self.gearRatio = 1.65;
			self.gearRatio = 0.3;
			ratio = 9;
		elseif self.currentGear == 8 then
			--self.gearRatio = 2;
			self.gearRatio = 0.35;
			ratio = 8.5;
		elseif self.currentGear == 9 then
			--self.gearRatio = 3;
			self.gearRatio = 0.4;
			ratio = 8;
		elseif self.currentGear == 10 then
			--self.gearRatio = 4;
			self.gearRatio = 0.5;
			ratio = 7.5;
		elseif self.currentGear == 11 then
			--self.gearRatio = 5;
			self.gearRatio = 0.55;
			ratio = 7;
		elseif self.currentGear == 12 then
			--self.gearRatio = 6;
			self.gearRatio = 0.6;
			ratio = 6.5;
		elseif self.currentGear == 13 then
			--self.gearRatio = 7;
			self.gearRatio = 0.65;
			ratio = 6;
		elseif self.currentGear == 14 then
			--self.gearRatio = 8;
			self.gearRatio = 0.7;
			ratio = 5.5;
		elseif self.currentGear == 15 then
			--self.gearRatio = 9;
			self.gearRatio = 0.75;
			ratio = 5;
		elseif self.currentGear == 16 then
			--self.gearRatio = 10.5;
			self.gearRatio = 0.8;
			ratio = 4.5;
		elseif self.currentGear == 17 then
			--self.gearRatio = 12;
			self.gearRatio = 0.85;
			ratio = 4.2;
		elseif self.currentGear == 18 then
			--self.gearRatio = 13;
			self.gearRatio = 1;
			ratio = 4.1;
		elseif self.currentGear == -1 then
			--self.gearRatio = 0.5;
			self.gearRatio = -0.07;
			ratio = 13.5;
		elseif self.currentGear == -2 then
			--self.gearRatio = 1;
			self.gearRatio = -0.3;
			ratio = 9;
		end;
		
		self.motor.backwardGearRatio = ratio;
		self.motor.forwardGearRatios = {ratio/2,ratio/1.5,ratio};
				
		local acceleration = 0;
		local newAcceleration = 0;
		if g_currentMission.allowSteerableMoving and not self.playMotorSound then
			acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
if InputBinding.isAxisZero(acceleration) then
acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
end;
			
			if math.abs(acceleration) > 0.8 then
				self.motor:setSpeedLevel(0, true)
			end;
			if self.motor.speedLevel ~= 0 then
				acceleration = 1.0;
			end;
		end;
		
		newAcceleration = acceleration;
		if acceleration <= 0 and self.throttlePercentage < self.powerShiftMinRpm/self.motorMaxRpmLimit[3] then
			newAcceleration = 0;
		elseif self.throttlePercentage > self.powerShiftMinRpm/self.motorMaxRpmLimit[3] and acceleration <= 0 then
			newAcceleration = self.throttlePercentage;
		end;
		
		if self.throttleLeaver ~= nil then
			setRotation(self.throttleLeaver, Utils.degToRad(self.throttlePercentage * -40),0,0);
		end;
		
		--Pedal animation management for pedals
		if InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD) ~= 0 then
			--user has a speeder pedal
			self:speederAnimation(dt, acceleration, newAcceleration);
		else
			--user is using buttons
			self:speederAnimation(dt, newAcceleration, newAcceleration);
		end;
		self:brakeAnimation(dt, acceleration);
		self:clutchAnimation(dt, acceleration);

		-- Slow rev up and down	
		if math.floor(newAcceleration*100) >  math.floor(self.lastAcceleration*100) and self.currentGear == 0 then
			newAcceleration = self.lastAcceleration + 0.0006 * dt;
			self.lastAcceleration = newAcceleration;
		elseif math.floor(newAcceleration*100) <  math.floor(self.lastAcceleration*100) and self.currentGear == 0 then
			newAcceleration = self.lastAcceleration - 0.0005 * dt; 
			self.lastAcceleration = newAcceleration;
		elseif math.floor(newAcceleration*100) >  math.floor(self.lastAcceleration*100) then
			newAcceleration = self.lastAcceleration + (0.0005 * dt - (self.gearRatio/150));
			self.lastAcceleration = newAcceleration;
		elseif math.floor(newAcceleration*100) <  math.floor(self.lastAcceleration*100) then
			newAcceleration = self.lastAcceleration - (0.0005 * dt - (self.gearRatio/150)); 
			self.lastAcceleration = newAcceleration;
		end;
		
		if newAcceleration < acceleration and acceleration > 0 and self.isMotorStarted then
			self.showExtraParticles = true;
		else
			self.showExtraParticles = false;
		end;
		
		-- Always have acceleration when i gear like on a real tractor;
		if newAcceleration <= self.powerShiftMinRpm/self.motorMaxRpmLimit[3] then
			newAcceleration = self.powerShiftMinRpm/self.motorMaxRpmLimit[3];
		end;
		
		--Extra smoke particles
		Utils.setEmittingState(self.extraExhaustParticleSystems, self.showExtraParticles);
		
		local mySpeed = self.lastSpeed*3600;
		
		-- Automatic gearbox
		if self.automaticGearbox then
			if self.automaticGearBoxMode > 0 then
				if newAcceleration >= 0.95 and acceleration > 0 then
					self.currentGear = self.currentGear + 1;
					if self.currentGear > self.noOfForwardGears then
						self.currentGear = self.noOfForwardGears;
					end;
				elseif newAcceleration <= 1 and acceleration < 0 then
					self.currentGear = self.currentGear - 1;
					if self.currentGear == 0 then
						self.currentGear = 1;
					end;
				end;
			elseif self.automaticGearBoxMode < 0 then
				if newAcceleration >= 0.95 and acceleration > 0 then
					self.currentGear = self.currentGear - 1;
					if self.currentGear > self.noOfForwardGears then
						self.currentGear = self.noOfForwardGears;
					end;
				elseif newAcceleration <= 1 and acceleration < 0 then
					self.currentGear = self.currentGear + 1;
					if self.currentGear == 0 then
						self.currentGear = -1;
					end;
				end;
			end;
		end;
		
		-- Acceleration adjustment when gearing up or down and gearshift modes
		if 	self.lastGear < self.currentGear and self.currentGear > 0 then 
			if mySpeed > 2 then
				if acceleration >= 0 and newAcceleration > 0 then
					self.lastAcceleration = self.lastAcceleration - 0.3;
					if self.lastAcceleration < 0.2 then
						self.lastAcceleration = 0.2;
					end;
				end;
			end;
			self.lastGearShiftMode = 2;
			if self:getIsActiveForSound() then
				if not self.GearShiftPlaying then
					playSample(self.GearShiftSoundId, 1, 1, 0);
				end;
			end;
		elseif self.lastGear > self.currentGear and self.currentGear > 0 then 
			if mySpeed > 2 then
				if acceleration >= 0 and newAcceleration > 0 then
					self.lastAcceleration = self.lastAcceleration + 0.2;
					if self.lastAcceleration > 1.7 then
						self.lastAcceleration = 1.7;
					end;
				end;
			end;
			self.lastGearShiftMode = 1;
			if self:getIsActiveForSound() then
				if not self.GearShiftPlaying then
					playSample(self.GearShiftSoundId, 1, 1, 0);
				end;
			end;
		elseif self.lastGear > 0 and self.currentGear == 0 then
			if not self.GearShiftPlaying then
				playSample(self.GearShiftSoundId, 1, 1, 0);
			end;
			self.lastGearShiftMode = 3;
		elseif self.lastGear == 0 and self.currentGear < 0 then
			if not self.GearShiftPlaying then
				playSample(self.GearShiftSoundId, 1, 1, 0);
			end;
			self.lastGearShiftMode = 5;
		elseif 	self.lastGear < self.currentGear and self.currentGear < 0 then 
			if mySpeed > 2 then
				if acceleration >= 0 and newAcceleration > 0 then
					self.lastAcceleration = self.lastAcceleration + 0.1;
					if self.lastAcceleration > 1.5 then
						self.lastAcceleration = 1.5;
					end;
				end;
			end;
			self.lastGearShiftMode = 5;
			if self:getIsActiveForSound() then
				if not self.GearShiftPlaying then
					playSample(self.GearShiftSoundId, 1, 1, 0);
				end;
			end;
		elseif self.lastGear > self.currentGear and self.currentGear < 0 then 
			if mySpeed > 2 then
				if acceleration >= 0 and newAcceleration > 0 then
					self.lastAcceleration = self.lastAcceleration - 0.3;
					if self.lastAcceleration < 0.2 then
						self.lastAcceleration = 0.2;
					end;
				end;
			end;
			self.lastGearShiftMode = 6;
			if self:getIsActiveForSound() then
				if not self.GearShiftPlaying then
					playSample(self.GearShiftSoundId, 1, 1, 0);
				end;
			end;
		elseif self.lastGear < 0 and self.currentGear == 0 then
			if not self.GearShiftPlaying then
				playSample(self.GearShiftSoundId, 1, 1, 0);
			end;
			self.lastGearShiftMode = 7;
		end;
		
		--gear leaver animation management
		if self.lastGearShiftMode == 1 then
			self:gearUpForward(dt, self.currentGear);
		elseif self.lastGearShiftMode == 2 then
			self:gearDownForward(dt, self.currentGear);
		elseif self.lastGearShiftMode == 3 then
			self:gearForwardToNeutral(dt, self.currentGear);
		elseif self.lastGearShiftMode == 5 then
			self:gearUpReverse(dt, self.currentGear);
		elseif self.lastGearShiftMode == 6 then
			self:gearDownReverse(dt, self.currentGear);
		elseif self.lastGearShiftMode == 7 then
			self:gearReverseToNeutral(dt, self.currentGear);
		end;
		
		--RPM meter value
		self.rpmMeterValue = newAcceleration * self.motorMaxRpmLimit[3];
				
		--Throttle Sound	
		local roundPerSecond = 0;
		
		if self.lastAcceleration > 0 then
			if acceleration >= 0 and self.gearRatio > 0 then
				roundPerSecond = self.lastAcceleration * 32 - (self.gearRatio*8);
			elseif acceleration >= 0 and self.gearRatio < 0 then
				roundPerSecond = self.lastAcceleration * 32 + (self.gearRatio*8);
			else
				roundPerSecond = self.lastAcceleration * 32;
			end;
			if roundPerSecond < 0 then
				roundPerSecond = 0;
			end;
		end;

		if self.motorSound ~= nil then
			 setSamplePitch(self.motorSound, math.min(self.motorSoundPitchOffset + self.motorSoundPitchScale*math.abs(roundPerSecond), self.motorSoundPitchMax));

			if self.motorSoundRun ~= nil then
				setSamplePitch(self.motorSoundRun, math.min(self.motorSoundRunPitchOffset + self.motorSoundRunPitchScale*math.abs(roundPerSecond), self.motorSoundRunPitchMax));
			end;

		end;
		
		if self.motorSoundRun ~= nil then

			local maxRpm  = self.motor.maxRpm[3];

			if newAcceleration > 0 then
				local rpmVolume = Utils.clamp(math.abs(roundPerSecond*60)/((maxRpm - self.motor.minRpm)), 0.0, 1.0);
				setSampleVolume(self.motorSoundRun, rpmVolume);
			else
				local rpmVolume = Utils.clamp(math.abs(roundPerSecond*60)/((maxRpm - self.motor.minRpm)*2), 0.0, 1.0);
				setSampleVolume(self.motorSoundRun, rpmVolume);
			end;

		end;
		--Throttlesound done
		
		
		if self.currentGear > 0 and self.isMotorStarted then
			newAcceleration = (self.gearRatio) * newAcceleration;--((5 + (self.gearRatio))/self.noOfForwardGears) * newAcceleration;
		elseif self.currentGear < 0 and self.isMotorStarted then
			newAcceleration = (self.gearRatio) * newAcceleration;
		else
			newAcceleration = 0;
		end;

		if self.fuelFillLevel == 0 then
			newAcceleration = 0;
		end;
		
		--disable handbrake when we start to move
		if self.handbrakeOn and newAcceleration > 0 then
			self.handbrakeOn = false;
		end;		
		
		self.motor.brakeForce = 0.000001;
		--Handle brake as brake
		if acceleration < 0 then
			self.motor.brakeForce = 4 * -acceleration;
			if self.firstTimeRun then
				WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 1);
			end;
		elseif self.handbrakeOn then
			self.motor.brakeForce = 4;
			if self.firstTimeRun then
				WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 1);
			end;
		else
			if self.firstTimeRun then
				WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, newAcceleration, false, 1);
			end;
		end;
	elseif not self.isAITractorActivated and not self.isAutopilotActivated then
		--Tractor is not entered or hired in any way so we sets "parking" brake on her
		self.motor.brakeForce = 4;
		if self.firstTimeRun then
			WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 1);
		end;
	end;

	self.lastGear = self.currentGear;
end;

function powerShift:gearUpForward(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(20);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(-10);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, true);
	end;
end;

function powerShift:gearUpDva(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(0);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(-10);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, true);
	end;
end;

function powerShift:gearUpTri(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(20);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(0);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, true);
	end;
end;

function powerShift:gearDownForward(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(0);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(-10);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(20);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(-10);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, false);
	end;
end;

function powerShift:gearForwardToNeutral(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(0);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(0);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, false);
	end;
end;

function powerShift:gearUpReverse(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(-10);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(-10);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, true);
	end;
end;

function powerShift:gearDownReverse(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(-20);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(-10);
		local gearLeaverRotationTime = 100;
		if gearLeaverRotationTime == 100 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, false);
	end;
end;

function powerShift:gearReverseToNeutral(dt, currentGear)
	if self.gearLeaver ~= nil then
		local gearLeaverMax = {};
		gearLeaverMax[1] = Utils.degToRad(0);
		gearLeaverMax[2] = Utils.degToRad(0);
		gearLeaverMax[3] = Utils.degToRad(0);
		local gearLeaverRotationTime = 0;
		if gearLeaverRotationTime == 0 then
			gearLeaverRotationTime = 100;
		end;
		
		local gearLeaverMin = {};
		gearLeaverMin[1] = Utils.degToRad(0);
		gearLeaverMin[2] = Utils.degToRad(0);
		gearLeaverMin[3] = Utils.degToRad(0);
		
		self:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, false);
	end;
end;


function powerShift:gearleaverAnimation(dt, gearLeaverMax, gearLeaverMin, gearLeaverRotationTime, gearingUp)
	if self.gearLeaver ~= nil then
		local x, y, z = getRotation(self.gearLeaver);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, gearLeaverMin, gearLeaverMax, 3, gearLeaverRotationTime, dt, gearingUp);
		setRotation(self.gearLeaver, unpack(newRot));
	end;
end;

function powerShift:speederAnimation(dt, acceleration, newAcceleration)
	if self.speeder ~= nil then
		--[[local speederActive = false;
		if acceleration >= 0 then
			speederActive = true;
		end;
		
		local speederMax = {};
		speederMax[1] = Utils.degToRad(25 * math.abs(acceleration));
		speederMax[2] = Utils.degToRad(0);
		speederMax[3] = Utils.degToRad(0);
		local speederRotationTime = 0;
		
		local speederMin = {};
		speederMin[1] = Utils.degToRad(0);
		speederMin[2] = Utils.degToRad(0);
		speederMin[3] = Utils.degToRad(0);
		
		local x, y, z = getRotation(self.speeder);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, speederMin, speederMax, 3, speederRotationTime, dt, speederActive);
		setRotation(self.speeder, unpack(newRot));
		]]--
		if acceleration > 0 then
			setRotation(self.speeder, Utils.degToRad(25 * math.abs(acceleration)),0,0);
		elseif newAcceleration > 0 then
			setRotation(self.speeder, Utils.degToRad(25 * math.abs(newAcceleration)),0,0);
		else
			setRotation(self.speeder, Utils.degToRad(0),0,0);
		end;
	end;
end;
	
function powerShift:clutchAnimation(dt, acceleration)
	if self.clutch ~= nil then
		local clutchActive = false;
		if acceleration < 0 then
			clutchActive = true;
		end;
		
		local clutchMax = {};
		clutchMax[1] = Utils.degToRad(-40);
		clutchMax[2] = Utils.degToRad(0);
		clutchMax[3] = Utils.degToRad(0);
		local clutchRotationTime = 500;
		
		local clutchMin = {};
		clutchMin[1] = Utils.degToRad(0);
		clutchMin[2] = Utils.degToRad(0);
		clutchMin[3] = Utils.degToRad(0);
		
		local x, y, z = getRotation(self.clutch);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, clutchMin, clutchMax, 3, clutchRotationTime, dt, clutchActive);
		setRotation(self.clutch, unpack(newRot));
	end;
end;

function powerShift:brakeAnimation(dt, acceleration)
	if self.brake ~= nil then
		--[[local brakeActive = false;
		if acceleration < 0 then
			brakeActive = true;
		end;
		
		local brakeMax = {};
		brakeMax[1] = Utils.degToRad(-40 * math.abs(acceleration));
		brakeMax[2] = Utils.degToRad(0);
		brakeMax[3] = Utils.degToRad(0);
		local speederRotationTime = 0;
		
		local speederMin = {};
		brakeMin[1] = Utils.degToRad(0);
		brakeMin[2] = Utils.degToRad(0);
		brakeMin[3] = Utils.degToRad(0);
		
		local x, y, z = getRotation(self.brake);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, brakeMin, brakeMax, 3, brakeRotationTime, dt, brakeActive);
		setRotation(self.brake, unpack(newRot));
		]]--
		if acceleration < 0 then
			setRotation(self.brake, Utils.degToRad(-25 * math.abs(acceleration)),0,0);
		else
			setRotation(self.brake, Utils.degToRad(0),0,0);
		end;
	end;
end;
