-- 
-- Container Arm Script by Zippo
-- 

ksk = {};

function ksk.prerequisitesPresent(specializations)
     return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ksk:load(xmlFile)

    	local translationA2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationA2#index"));
    if translationA2Node ~= nil then
        self.translationA2 = {};
        self.translationA2.node = translationA2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationA2#minTrans"));
        self.translationA2.minTrans = {};
        self.translationA2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationA2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationA2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationA2#maxTrans"));
        self.translationA2.maxTrans = {};
        self.translationA2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationA2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationA2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationA2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationA2#transTime"), 2)*1000;
        self.translationA2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationA2#touchTransLimit"), 10);
    end;

	local translationA5Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationA5#index"));
    if translationA5Node ~= nil then
        self.translationA5 = {};
        self.translationA5.node = translationA5Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationA5#minTrans"));
        self.translationA5.minTrans = {};
        self.translationA5.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationA5.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationA5.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationA5#maxTrans"));
        self.translationA5.maxTrans = {};
        self.translationA5.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationA5.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationA5.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationA5.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationA5#transTime"), 2)*1000;
        self.translationA5.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationA5#touchTransLimit"), 10);
    end;

end;	
      
function ksk:delete()
end;

function ksk:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function ksk:keyEvent(unicode, sym, modifier, isDown)
	if self.isMotorStarted then
	
	if sym == Input.KEY_KP_7 then
		self.translationA2Max = isDown;
	end;
	if sym == Input.KEY_KP_8 then
		self.translationA2Min = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationA5Max = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.translationA5Min = isDown;
	end;
      end;
end;

function ksk:update(dt)
				
if self.inrange then
	if InputBinding.hasEvent (InputBinding.KSK_DOOR) then
		self.translationA2Max = not self.translationA2Max;
		else
		self.translationA2Min = not self.translationA2Min;
	end;
end;

	if self.inrange then
		if self.translationA2Max then
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_6"), InputBinding.KSK_DOOR);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_7"), InputBinding.KSK_DOOR);
		end;
	end;	

	local doTranslate = self.translationA2Max or self.translationA2Min 
	if self.translationA2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationA2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationA2.maxTrans, self.translationA2.minTrans, 3, self.translationA2.transTime, dt, not self.translationA2Max); 
		setTranslation(self.translationA2.node, unpack(newTrans));
	end; 

	local doTranslate = self.translationA5Max or self.translationA5Min 
	if self.translationA5 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationA5.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationA5.maxTrans, self.translationA5.minTrans, 3, self.translationA5.transTime, dt, not self.translationA5Max); 
		setTranslation(self.translationA5.node, unpack(newTrans));
     end;		

end;

function ksk:updateTick(dt)

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;

end;

function ksk:draw()

     if self.isMotorStarted then
        g_currentMission:addExtraPrintText("NUMPAD 7 / 8 - Door");
	g_currentMission:addExtraPrintText("Key L - Work Light");
	g_currentMission:addExtraPrintText("");
	end;

end;

function ksk:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

