
RotatingPlates = {};

function RotatingPlates.prerequisitesPresent(specializations)
	return true;
end;

function RotatingPlates:load(xmlFile)
	self.rotPlates = {};
	local i=0;
	while true do
		local main = string.format("vehicle.rotPlates.plate(%d)", i);
		local rotPoint = getXMLString(xmlFile, main.. "#rotPoint");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, main.. "#rotTempo"));
		local rotTempo = {x,y,z};
		local timeTillOff = Utils.getNoNil(getXMLFloat(xmlFile, main.. "#timeTillOff"), 1);
		if rotPoint == nil or rotTempo == nil or timeTillOff == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, rotPoint);
		if node ~= nil then
			local var = {};
			var.node = node;
			var.timeTillOff = timeTillOff;
			var.rotTempoMax = rotTempo;
			var.rotTempoMin = {0,0,0};
			var.rotTempoNow = {0,0,0};
			table.insert(self.rotPlates, var);
		end;
		i = i+1;
	end;
end;

function RotatingPlates:delete()
end;

function RotatingPlates:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RotatingPlates:keyEvent(unicode, sym, modifier, isDown)
end;

function RotatingPlates:update(dt)
end;

function RotatingPlates:updateTick(dt)
	if self:getIsActive() then
		for s, plate in pairs(self.rotPlates) do
			local values = Utils.getMovedLimitedValues(plate.rotTempoNow, plate.rotTempoMax, plate.rotTempoMin, 3, plate.timeTillOff*2500, dt, not self.isTurnedOn);
			plate.rotTempoNow = values;
			rotate(plate.node, unpack(plate.rotTempoNow));
		end;
	end;
end;
 
function RotatingPlates:draw()
end;

function RotatingPlates:onAttach(attacherVehicle)
end;

function RotatingPlates:onDetach()
end;