--
-- FastCouplerFastCouplerPowerShaft
-- Specialization for FastCouplerPowerShaft
--
-- @author  Manuel Leithner
-- @date  10/08/09
--

FastCouplerPowerShaft = {};

function FastCouplerPowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FastCouplerAttachment, specializations);
end;

function FastCouplerPowerShaft:load(xmlFile)
	
	self.fastCouplerPowerShaft = {};		
	self.fastCouplerPowerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.fastCouplerPowerShaft.node);
	self.fastCouplerPowerShaft.rot = {x,y,z};
	self.fastCouplerPowerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.fastCouplerPowerShaft.part);
	self.fastCouplerPowerShaft.trans = {x,y,z};
	self.fastCouplerPowerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.fastCouplerPowerShaft.part);
	local bx, by, bz = getWorldTranslation(self.fastCouplerPowerShaft.fixPoint);		
	self.fastCouplerPowerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.attacherVehiclePowerShaft = nil;
	self.doPowerShaftJointSearch = false;
	
end;

function FastCouplerPowerShaft:delete()
end;

function FastCouplerPowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FastCouplerPowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function FastCouplerPowerShaft:update(dt)
	
	if self.doPowerShaftJointSearch then
		for i=1, table.getn(self.fastCouplerAttacher.attachedImplements) do
			if self.fastCouplerAttacher.attachedImplements[i].object == self.attacherVehicle then			
				local index = self.fastCouplerAttacher.attachedImplements[i].jointDescIndex;
				local joint = self.fastCouplerAttacher.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					--print(".................... >>> self.attacherVehiclePowerShaft ="..tostring(self.attacherVehiclePowerShaft));
					
					break;						
				end;
			end;
		end;
		self.doPowerShaftJointSearch = false;		
	end;
	
	if self:getIsActive() then				
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.fastCouplerPowerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.fastCouplerPowerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.fastCouplerPowerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.fastCouplerPowerShaft.part, 0, 0, distance-self.fastCouplerPowerShaft.distance);		
		end;		
	end;
	
end;

function FastCouplerPowerShaft:draw()
end;


function FastCouplerPowerShaft:onAttach(attacherVehicle)
	self.doPowerShaftJointSearch = true;
end;

function FastCouplerPowerShaft:onDetach()
	setTranslation(self.fastCouplerPowerShaft.part, unpack(self.fastCouplerPowerShaft.trans));
	setRotation(self.fastCouplerPowerShaft.node, unpack(self.fastCouplerPowerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
end;

function FastCouplerPowerShaft:onFastCouplerDetach()
	setTranslation(self.fastCouplerPowerShaft.part, unpack(self.fastCouplerPowerShaft.trans));
	setRotation(self.fastCouplerPowerShaft.node, unpack(self.fastCouplerPowerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
end;

function FastCouplerPowerShaft:onFastCouplerAttach(attacherVehicle)
	self.doPowerShaftJointSearch = true;
end;





