--
-- FastCoupler
-- Specialization for FastCoupler functionality
--
-- Modschmiede / LS-Modsource
-- @author  Manuel Leithner
-- @date  08/08/09
--

FastCoupler = {};

function FastCoupler.prerequisitesPresent(specializations)
    return true;
end;

function FastCoupler:load(xmlFile)
	_=[[
    local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;	

		local jointTypeStr = getXMLString(xmlFile, baseName .. "#jointType");
		if jointTypeStr ~= nil then
			local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
			
			if jointType == nil then
				Vehicle.registerJointType(jointTypeStr);
				print("register Jointtype: " .. jointTypeStr);
				jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
			end;
			
			if jointType ~= nil then
				self.attacherJoints[i+1].jointType = jointType;				
			end;
		end;
		i = i + 1;
	end;	]]	
	

	local jointTypeStr = getXMLString(xmlFile,"vehicle.attacherJoints.attacherJoint#jointType");
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		
		if jointType == nil then
			Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;
		
		if jointType ~= nil then
			self.attacherJoints[1].jointType = jointType;				
		end;
	end;

	self.attacherVehicleCopy = nil;
	
end;

function FastCoupler:delete()
end;

function FastCoupler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FastCoupler:keyEvent(unicode, sym, modifier, isDown)
end;

function FastCoupler:update(dt)	
end;

function FastCoupler:draw()
end;

function FastCoupler:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
    for k,v in pairs(self.attachedImplements) do	
		if v.object.onFastCouplerAttach ~= nil then
            v.object:onFastCouplerAttach(attacherVehicle);
		end;
    end;
end;

function FastCoupler:onDetach()
	self.attacherVehicleCopy = nil;
	for k,v in pairs(self.attachedImplements) do
		if v.object.onFastCouplerDetach ~= nil then
            v.object:onFastCouplerDetach(attacherVehicle);
		end;
    end;
end;
