 --
-- Easycut
-- Class for all easycuts
--
-- @author  Stefan Geiger 
-- @date  11/05/08	    
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

--[[  ## EDITS ##

15.05.2011 - FIAT80-90DT | swath function, particleSystem, copy to spec

]]--
 
Easycut = {};
  
function Easycut.prerequisitesPresent(specializations)
	Vehicle.registerJointType("fastCoupling");
	print('register JointType '..'"'..'fastCoupling'..'"' )
    return true;
end;
  
function Easycut:load(xmlFile)
  
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
   
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;      
    if self.isClient then
		local easycutSound = getXMLString(xmlFile, "vehicle.easycutSound#file");
		if easycutSound ~= nil and easycutSound ~= "" then
			easycutSound = Utils.getFilename(easycutSound, self.baseDirectory); 
			self.easycutSound = createSample("easycutSound");
			self.easycutSoundEnabled = false;
			loadSample(self.easycutSound, easycutSound, false);
			self.easycutSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.easycutSound#pitchOffset"), 1);
			self.easycutSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.easycutSound#volume"), 1);
		end;
	end;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	end;

	self.doCut = false;
	self.isTurnedOn = false;
	self.wasToFast = false;
	self.easycutGroundFlag = self.nextDirtyFlag;
	self.nextDirtyFlag = self.easycutGroundFlag*2;
	
-- Drop - ablegen
	local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
	if numWindrowerDropAreas == 0 then
		print("Warning: No drop areas specified in '"..self.configFileName.."'");
	else
		if numWindrowerDropAreas ~= 1 and numWindrowerDropAreas ~= table.getn(self.windrowerTakeAreas) then
			print("Warning: Number of takeing areas and drop areas should be equal in '"..self.configFileName.."'");
		end;
	end;
	self.windrowerDropAreas = {}
	for i=1, numWindrowerDropAreas do
		self.windrowerDropAreas[i] = {};
		local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
		self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	
-- cut - aufnehemen
	local numWindrowerTakeAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerTakeAreas#count"), 0);
	self.windrowerTakeAreas = {};
	self.accumulatedWindrowerTakeAreaValues = {};
	for i=1, numWindrowerTakeAreas do
		self.windrowerTakeAreas[i] = {};
		local areanamei = string.format("vehicle.windrowerTakeAreas.windrowerTakeArea%d", i);
		self.windrowerTakeAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerTakeAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerTakeAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
		self.accumulatedWindrowerTakeAreaValues[i] = 0;
	end;
-- ps - ParticleSystem
	self.particleSystems = {};
    local i = 0;
    while true do
        local systemi = string.format("vehicle.particleSystems.system(%d)", i);
		local indexi = Utils.indexToObject(self.components, getXMLString(xmlFile, systemi .. "#index"));
		if indexi == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystems, systemi, indexi, false, nil, self.baseDirectory)		
		i = i +1;		
    end;	
end;

function Easycut:delete()  
	if self.easycutSound ~= nil then
		delete(self.easycutSound);
	end;
end;
  
function Easycut:readStream(streamId, connection)
	local turnedOn = streamReadBool(streamId);
	self:setIsTurnedOn(turnedOn, true);
end;
 
function Easycut:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTurnedOn);
end;
  
function Easycut:readUpdateStream(streamId, timestamp, connection)
end;
  
function Easycut:writeUpdateStream(streamId, connection, dirtyMask)
end;
  
function Easycut:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function Easycut:keyEvent(unicode, sym, modifier, isDown)
end;

function Easycut:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
	end;
end;

function Easycut:updateTick(dt)
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn then
			local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
			if not toFast then 
				if self.isServer then
					local x,y,z = getWorldTranslation(self.groundReferenceNode);
	                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
	                if terrainHeight+self.groundReferenceThreshold >= y then
	--				--
						local foldAnimTime = self.foldAnimTime;
						local cuttingAreasSend = {};
						for k, cuttingArea in pairs(self.cuttingAreas) do
							if self:getIsAreaActive(cuttingArea) then
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
								table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							--Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
								local CheckArea = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);
								if CheckArea > 0 then
									self.showPS = true;
									Utils.setEmittingState(self.particleSystems, true);
								else
									self.showPS = false;
									Utils.setEmittingState(self.particleSystems, false);	
								end;
							end;
						end;
						if (table.getn(cuttingAreasSend) > 0) then
							MowerAreaEvent.runLocally(cuttingAreasSend);
							g_server:broadcastEvent(MowerAreaEvent:new(cuttingAreasSend));

						end;
	--				--
						local numDropAreas = table.getn(self.windrowerDropAreas);
						local numTakeAreas = table.getn(self.windrowerTakeAreas);
						if numDropAreas > 0 and numTakeAreas > 0 then
							local sum = 0;
							--local fruitType = FruitUtil.FRUITTYPE_GRASS;
							--local fruitTypeFix = false;
                            --local foldAnimTime = self.foldAnimTime;
							local takeAreasSend = {};
							local dropAreasSend = {};
							for i=1, numTakeAreas do
								local cuttingArea = self.windrowerTakeAreas[i];
								if self:getIsAreaActive(cuttingArea) then
									local x,y,z = getWorldTranslation(cuttingArea.start);
									local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
									local x2,y2,z2 = getWorldTranslation(cuttingArea.height);  
									
									table.insert(takeAreasSend, {x,z,x1,z1,x2,z2});
								end;
							end;
							for i=1, numDropAreas do
								local dropArea = self.windrowerDropAreas[i];
								local dx,dy,dz = getWorldTranslation(dropArea.start);
								local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
								local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
								
								table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2});
							end;
							if table.getn(takeAreasSend) > 0 then
								local takeAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(takeAreasSend, dropAreasSend, self.accumulatedWindrowerTakeAreaValues);
								if table.getn(takeAreasSend) > 0 then
									g_server:broadcastEvent(WindrowAreaEvent:new(takeAreasSend, dropAreasSend, fruitType, bitType));
								end;
							end;
						end;
					else
						if self.showPS then
							self.showPS = false;
							Utils.setEmittingState(self.particleSystems, false);
						end;
					end;
				end;
			end;
			if self.isClient then
				if not self.easycutSoundEnabled and self:getIsActiveForSound() then
					setSamplePitch(self.easycutSound, self.easycutSoundPitchOffset);
					playSample(self.easycutSound, 0, self.easycutSoundVolume, 0);
					self.easycutSoundEnabled = true;
				end;
			end;
			
			self.wasToFast = toFast;
		else
			if self.showPS then
				self.showPS = false;
				Utils.setEmittingState(self.particleSystems, false);
			end;
			if self.isClient then
				if self.easycutSoundEnabled then
					stopSample(self.easycutSound);
					self.easycutSoundEnabled = false;
				end;
			end;
		end;
	end;
end;

function Easycut:draw()
	if self.isClient then
		if self.isTurnedOn then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
			
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
		end;
		if self.wasToFast then
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
		end;
	end;
end;

function Easycut:onDetach()
	if self.deactivateOnDetach then
		Easycut.onDeactivate(self);
	else
		Easycut.onDeactivateSounds(self)
	end;
end

function Easycut:onLeave()
	if self.deactivateOnLeave then
		Easycut.onDeactivate(self);
	else
		Easycut.onDeactivateSounds(self)
	end;
end;

function Easycut:onDeactivate()
	Easycut.onDeactivateSounds(self)
	self.isTurnedOn = false;
end;

function Easycut:onDeactivateSounds()
	if self.isClient then
		if self.easycutSoundEnabled then
			stopSample(self.easycutSound);
			self.easycutSoundEnabled = false;
		end;
	end;
end;

function Easycut:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
end;