SetUnloadingEvent = {};
SetUnloadingEvent_mt = Class(SetUnloadingEvent, Event);

InitEventClass(SetUnloadingEvent, "SetUnloadingEvent");

function SetUnloadingEvent:emptyNew()
    local self = Event:new(SetUnloadingEvent_mt);
    self.className = "SetUnloadingEvent";
    return self;
end;

function SetUnloadingEvent:new(object, isUnloading)
    local self = SetUnloadingEvent:emptyNew()
    self.object = object;
	self.isUnloading = isUnloading;
    return self;
end;

function SetUnloadingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isUnloading = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetUnloadingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isUnloading);
end;

function SetUnloadingEvent:run(connection)
	self.object:setUnloadingState(self.isUnloading, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetUnloadingEvent:new(self.object, self.isUnloading), nil, connection, self.object);
    end;	
end;

function SetUnloadingEvent.sendEvent(vehicle, isUnloading, noEventSend)
	if isUnloading ~= vehicle.isUnloading then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetUnloadingEvent:new(vehicle, isUnloading), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetUnloadingEvent:new(vehicle, isUnloading));
			end;
		end;
	end;
end;

