DropBaleEvent = {};
DropBaleEvent_mt = Class(DropBaleEvent, Event);
 
InitEventClass(DropBaleEvent, "DropBaleEvent");

function DropBaleEvent:emptyNew()
    local self = Event:new(DropBaleEvent_mt);
    self.className="DropBaleEvent";
    return self;
end;

function DropBaleEvent:new(object, baleIndex, baleTime)
    local self = DropBaleEvent:emptyNew()
    self.baleIndex = baleIndex;
    self.baleTime = baleTime;
    self.object = object;
    return self;
end;

function DropBaleEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.baleIndex = streamReadInt8(streamId);
    self.baleTime = streamReadFloat32(streamId);
    self:run(connection);
end;

function DropBaleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.baleIndex);
    streamWriteFloat32(streamId, self.baleTime);
end;

function DropBaleEvent:run(connection)
    print("creating bale");
    self.object:dropBale(self.baleIndex);
end;