--


pickupGrassSwads = {};

function pickupGrassSwads.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function pickupGrassSwads:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"),0.5);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    self.cuttingAreas = nil;
    self.cuttingAreas = {};
    self.cuttingAreasN = {};
    for i=1, numCuttingAreas do
        self.cuttingAreasN[i] = {};
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreasN[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasN[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasN[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

end;

function pickupGrassSwads:delete()

end;

function pickupGrassSwads:readStream(streamId, connection)
end;

function pickupGrassSwads:writeStream(streamId, connection)
	
end;

function pickupGrassSwads:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pickupGrassSwads:keyEvent(unicode, sym, modifier, isDown)

end;

function pickupGrassSwads:update(dt)
		

end;

function pickupGrassSwads:updateTick(dt)
	--if self.reelStarted then
	if self.reelStarted and self.movingDirection < 0 then
        local hasGroundContact = false;
        local x,y,z = getWorldTranslation(self.groundReferenceNode);
        local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
        if terrainHeight+self.groundReferenceThreshold >= y then
            hasGroundContact = true;
        end;
		if hasGroundContact then
			local realArea = 0;
			for k,area in pairs(self.cuttingAreasN) do
				for fruitType,v in pairs(self.fruitTypes) do
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);
					
					local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
					area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
					if area > 0 then
						self.currentFruitType = FruitUtil.FRUITTYPE_GRASS;
						self.lastArea = self.lastArea + area;
						realArea = realArea + area/g_currentMission.maxFruitValue;
					end;
				end;
				self.lastArea = self.lastArea *10;
			end;
		
			local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
			local qm = realArea*pixelToQm;
			local ha = qm/10000;
			
			g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
			g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

			g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
			g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);

		end;
	end;
end;


function pickupGrassSwads:draw()	

end;

function pickupGrassSwads:onAttach(attacherVehicle)
end;

function pickupGrassSwads:onDetach()

end;

function pickupGrassSwads:onLeave()

end;

function pickupGrassSwads:onDetach()

end;
