--
-- hectars
--
-- @author  JS39
-- @date  25/08/09
--
-- http://www.virtualfarming.de/
--
-- Copyright () JS39

hectars = {};

function hectars.prerequisitesPresent(specializations)
return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function hectars:load(xmlFile)
self.TreshedNumber = 0;
self.TreshedTotalNumber = 0;
function hectars:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
   self.TreshedTotalNumber = TreshedTotalNumber;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function hectars:getSaveAttributesAndNodes(nodeIdent)
   local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
    local attributes = 'TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'"';
   return attributes, nil;
end;

function hectars:delete()
end;

function hectars:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hectars:keyEvent(unicode, sym, modifier, isDown)
end;

function hectars:update(dt)

if self.treshingMaschineActive then
local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
end;

end;
function hectars:draw() 
   setTextBold(true);
                renderText(0.78, 0.84, 0.02, string.format("Hecktar Tag %.1f", self.TreshedNumber));
    			renderText(0.78, 0.82, 0.02, string.format("Hecktar Gesamt %.1f", self.TreshedTotalNumber));
	setTextBold(false);
end;
end;

