--
-- SiliermittelPallet
-- Specialization for Siliermittel change
--
-- @author  	JoXXer
-- @version 	v1.0
-- @date  		16/11/11
-- @history:	v1.0 - Initial version
--

SiliermittelPallet = {};

function SiliermittelPallet.prerequisitesPresent(specializations)
    return true;
end;

function SiliermittelPallet:load(xmlFile)

	self.changeSiliermittel = SpecializationUtil.callSpecializationsFunction("changeSiliermittel");

	self.SiliermittelPalletTriggerCallback = SiliermittelPallet.SiliermittelPalletTriggerCallback;

	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SiliermittelPallet#checkString"), "SiliermittelChange")
	self.usingTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SiliermittelPallet#activationTrigger"));


	addTrigger(self.usingTrigger, "SiliermittelPalletTriggerCallback", self);
    self.deleteListenerId = addDeleteListener(self.usingTrigger, "SiliermittelDelete", self);

	self.SiliermittelPalletVehicle = nil;
	self.SiliermittelCapacity = 1000;
end;

function SiliermittelPallet:delete()
    removeTrigger(self.usingTrigger);
end;

function SiliermittelPallet:wheelDelete()
    removeDeleteListener(self.usingTrigger, self.deleteListenerId);
end;

function SiliermittelPallet:readStream(streamId, connection)
	self.SiliermittelCapacity = streamReadInt16(streamId);
end;

function SiliermittelPallet:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.SiliermittelCapacity);
end;

function SiliermittelPallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SiliermittelPallet:keyEvent(unicode, sym, modifier, isDown)
end;

function SiliermittelPallet:update(dt)
end;

function SiliermittelPallet:updateTick(dt)

end;

function SiliermittelPallet:draw()
end;

function SiliermittelPallet:SiliermittelPalletTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local vehicle = g_currentMission.controlledVehicle;
	if vehicle ~= nil then
		if onEnter or onStay then
			if vehicle.rootNode == otherId then
				if vehicle.SiliermittelChange ~= nil then
					if vehicle.SiliermittelChange.checkString == self.checkString then
						if self.SiliermittelPalletVehicle ~= nil then
							if self.SiliermittelPalletVehicle == vehicle then
								vehicle.SiliermittelChange.SiliermittelInRange = self;
							end;
						else
							vehicle.SiliermittelChange.SiliermittelInRange = self;
						end;
					end;
				end;
			end;
		elseif onLeave then
			if otherId == vehicle.rootNode then
				if vehicle.SiliermittelChange ~= nil then
					vehicle.SiliermittelChange.SiliermittelInRange = nil;
				end;
			end;
		end;
	end;
end;

function SiliermittelPallet:changeSiliermittel(vehicle, noEventSend)
	SiliermittelChangeEvent.sendEvent(self, vehicle, noEventSend);

	if vehicle.SiliermittelChange ~= nil then
		self.SiliermittelPalletVehicle = vehicle;
		self.SiliermittelPalletVehicle:changeSiliermittel(self);
	end;
end;

function SiliermittelPallet:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#SiliermittelCapacity");
		if valueInt ~= nil then
			self.SiliermittelCapacity = valueInt;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function SiliermittelPallet:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;

	attributes = 'SiliermittelCapacity="'.. self.SiliermittelCapacity .. '"';

	return attributes, nil;
end;




