--
-- SiliermittelChange
-- Specialization for changing Siliermittel
--
-- @author	JoXXer
-- @date  	16/11/11
--

SiliermittelChange = {};

function SiliermittelChange.prerequisitesPresent(specializations)
    return true;
end;

function SiliermittelChange:load(xmlFile)

	self.changeSiliermittel = SpecializationUtil.callSpecializationsFunction("changeSiliermittel");

	self.SiliermittelChange = {};
	self.SiliermittelChange.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SiliermittelChange#SiliermittelChangeCheckString"), "SiliermittelChange");
	self.SiliermittelChange.SiliermittelInRange = nil;


	self.shouldChangeSiliermittel = false;
	self.nextSiliermittelChange = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.SiliermittelChange#firstSiliermittelChange"), 200)
	self.SiliermittelChangeInterval = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.SiliermittelChange#interval"), 200)

	self.checkSiliermittelOverlay = Overlay:new("hudcheckSiliermittelOverlay", Utils.getFilename("CheckEngineSiliermittel.dds", self.baseDirectory), 0.915, 0.32, 0.04125, 0.05);
end;

function SiliermittelChange:delete()

end;

function SiliermittelChange:readStream(streamId, connection)
    self.shouldChangeSiliermittel = streamReadBool(streamId);
    self.nextSiliermittelChange = streamReadInt32(streamId);
end;

function SiliermittelChange:writeStream(streamId, connection)
    streamWriteBool(streamId, self.shouldChangeSiliermittel);
    streamWriteInt32(streamId, self.nextSiliermittelChange);
end;

function SiliermittelChange:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SiliermittelChange:keyEvent(unicode, sym, modifier, isDown)
end;

function SiliermittelChange:update(dt)
	if self:getIsActive() then

		local SiliermittelChange = self.SiliermittelChange;
		local SiliermittelWarning = (self.nextSiliermittelChange * 200) * 0.9;

		if SiliermittelChange.SiliermittelInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.CHANGE_Siliermittel) then
					if SiliermittelWarning < self.operatingTime and SiliermittelChange.SiliermittelInRange.SiliermittelCapacity >= 10 then
						SiliermittelChange.SiliermittelInRange:changeSiliermittel(self);
					end;
				end;
				if SiliermittelChange.SiliermittelInRange.SiliermittelCapacity == 0 then
					g_currentMission:addWarning(g_i18n:getText("Out_Of_Siliermittel") .. "\n" .. g_i18n:getText("Buy_More_Siliermittel"));
				end;
			end;
		end;

		

		if self.isMotorStarted then
			if SiliermittelWarning < self.operatingTime then
				setVisibility(self.SiliermittelLight, true);
			else
				setVisibility(self.SiliermittelLight, false);
			end;
		end;
		if self.ignitionMode == 0 and self.ignitionMode ~= nil then
			setVisibility(self.SiliermittelLight, false)
		end;
	end;
end;

function SiliermittelChange:draw()
	local SiliermittelChange = self.SiliermittelChange;
	local SiliermittelWarning = (self.nextSiliermittelChange * 200) * 0.9;

	if SiliermittelChange.SiliermittelInRange ~= nil then
		if SiliermittelWarning < self.operatingTime then
			g_currentMission:addHelpButtonText(g_i18n:getText("CHANGE_Siliermittel"), InputBinding.CHANGE_Siliermittel);

		end;
	end;

	if SiliermittelWarning < self.operatingTime then
		self.checkSiliermittelOverlay:render();
	end;

	

end;

function SiliermittelChange:changeSiliermittel(SiliermittelChange)
	if SiliermittelChange.SiliermittelPalletVehicle ~= nil then
		SiliermittelChange.SiliermittelCapacity = SiliermittelChange.SiliermittelCapacity - 10;
		self.shouldChangeSiliermittel = false;
		self.nextSiliermittelChange = self.nextSiliermittelChange + self.SiliermittelChangeInterval;
	end;
end;

function SiliermittelChange:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#nextSiliermittelChange");
		if valueInt ~= nil then
			self.nextSiliermittelChange = valueInt;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function SiliermittelChange:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;

	attributes = 'nextSiliermittelChange="'.. self.nextSiliermittelChange .. '"';

	return attributes, nil;
end;
