--IFA L60
--powered by hz888
--hz888@freemail.hu

IFAL60 = {};

function IFAL60.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IFAL60:load(xmlFile)


    local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
        brakeSound = Utils.getFilename(brakeSound, self.baseDirectory);
        self.brakeSound = createSample("brakeSound");
        self.brakeSoundEnabled = false;
        loadSample(self.brakeSound, brakeSound, false);
        self.brakeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound#pitchOffset"), 1);
        self.brakeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound#volume"), 1);
    end;


	handbrakeSoundFile = Utils.getFilename("sound/brake2.wav", self.baseDirectory);
	self.handbrakeSoundId = createSample("handbrakeSound");
	loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);

	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
	self.turn1SoundId = createSample("turn1Sound");
	loadSample(self.turn1SoundId, turn1SoundFile, false);

	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
	self.turn2SoundId = createSample("turn2Sound");
	loadSample(self.turn2SoundId, turn2SoundFile, false);


    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

	self.kardan1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kardan1#index"));
	self.kardan2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kardan2#index"));

local translationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation2#index"));
      if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
        self.translation2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#touchTransLimit"), 10);
    end;
local translationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translation1#index"));
      if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
        self.translation1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#touchTransLimit"), 10);
    end;
local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
  local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;
local rotationPartNodeabl3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl3#index"));
    if rotationPartNodeabl3 ~= nil then
        self.rotationPartabl3 = {};
        self.rotationPartabl3.node = rotationPartNodeabl3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl3#minRot"));
        self.rotationPartabl3.minRot = {};
        self.rotationPartabl3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl3#maxRot"));
        self.rotationPartabl3.maxRot = {};
        self.rotationPartabl3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl3#rotTime"), 2)*1000;
        self.rotationPartabl3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl3#touchRotLimit"), 10));
    end;
local rotationPartNodeabl4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl4#index"));
    if rotationPartNodeabl4 ~= nil then
        self.rotationPartabl4 = {};
        self.rotationPartabl4.node = rotationPartNodeabl4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl4#minRot"));
        self.rotationPartabl4.minRot = {};
        self.rotationPartabl4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl4#maxRot"));
        self.rotationPartabl4.maxRot = {};
        self.rotationPartabl4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl4#rotTime"), 2)*1000;
        self.rotationPartabl4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl4#touchRotLimit"), 10));
    end;
local rotationPartNodeabl5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl5#index"));
    if rotationPartNodeabl5 ~= nil then
        self.rotationPartabl5 = {};
        self.rotationPartabl5.node = rotationPartNodeabl5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl5#minRot"));
        self.rotationPartabl5.minRot = {};
        self.rotationPartabl5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl5#maxRot"));
        self.rotationPartabl5.maxRot = {};
        self.rotationPartabl5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl5#rotTime"), 2)*1000;
        self.rotationPartabl5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl5#touchRotLimit"), 10));
    end;

    self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;

    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

    self.numFlashlightsLeft = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flashlightsLeft#count"), 0);
    self.flashlightsLeft = {};
    for i=1, self.numFlashlightsLeft do
        local flashlightLeftnamei = string.format("vehicle.flashlightsLeft.flashlightLeft" .. "%d", i);
        self.flashlightsLeft[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, flashlightLeftnamei .. "#index"));
        setVisibility(self.flashlightsLeft[i], false);
    end;
	
    self.numFlashlightsRight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flashlightsRight#count"), 0);
    self.flashlightsRight = {};
    for i=1, self.numFlashlightsRight do
        local flashlightRightnamei = string.format("vehicle.flashlightsRight.flashlightRight" .. "%d", i);
        self.flashlightsRight[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, flashlightRightnamei .. "#index"));
        setVisibility(self.flashlightsRight[i], false);
    end;

    self.handbrake = true;
    self.farlightsActive = false;
    self.frontlightsActive = false;
    self.lightsActive = false;
    self.brakelightsActive = false;
    self.flashlightsLeftActive = false;
    self.flashlightsRightActive = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;

end;

function IFAL60:delete()

    if self.brakeSound ~= nil then
        delete(self.brakeSound);
    end;

end;

function IFAL60:mouseEvent(posX, posY, isDown, isUp, button)

end;

function IFAL60:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == self.keys.bajto then 
		self.rotationMaxabl1 = not self.rotationMaxabl1;
	end;
	if isDown and sym == self.keys.jajto then 
		self.rotationMaxabl2 = not self.rotationMaxabl2;
	end;
	if isDown and sym == self.keys.szerszamos then 
		self.rotationMaxabl3 = not self.rotationMaxabl3;
	end;
	if isDown and sym == self.keys.fulke then 
		self.rotationMaxabl4 = not self.rotationMaxabl4;
	end;
	if isDown and sym == self.keys.homlokfal then 
		self.rotationMaxabl5 = not self.rotationMaxabl5;	
	end;
    	if sym == self.keys.jablakfel then
		self.translation1Max = isDown;
	end;
	if sym == self.keys.jablakle then
		self.translation1Min = isDown;
	end;
    	if sym == self.keys.bablakfel then
		self.translation2Max = isDown;
	end;
	if sym == self.keys.bablakle then
		self.translation2Min = isDown;
	end;

	if isDown and sym == (self.keys.kezifek) then
		self.handbrake = not self.handbrake
		if self.handbrake then
		playSample(self.handbrakeSoundId, 1, 1, 0);
		end;
	end;

	if isDown and sym == (self.keys.tavolsagi) and self.light then
		self.farlightsActive = not self.farlightsActive;
	end;

	if isDown and sym == 96 then
		self.helpPanel = not self.helpPanel;
	end;

	if isDown and sym == (self.keys.indexL) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
	end;
	if isDown and sym == (self.keys.indexR) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
	end;
	if isDown and sym == (self.keys.elakadas) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
	end;

end;

function IFAL60:update(dt)

            self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

            if InputBinding.isAxisZero(self.input) then
                self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
            end;


            if self.brakeSound ~= nil then
		if self.movingDirection > 0 then
                	if -self.input < -0.001 and self.brakeSoundEnabled then
                    		self.brakeSoundEnabled = false;
                	end;

                	if -self.input < -0.001 and not self.brakeSoundEnabled then
                    		if self:getIsActiveForSound() then
                        		playSample(self.brakeSound, 1, self.brakeSoundVolume, 0);
                        		setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
					self.motor.brakeForce = 50;
                    		end;
                    		self.brakeSoundEnabled = true;
			end;
                end;
		if self.movingDirection < 0 then
                	if -self.input > 0.001 and self.brakeSoundEnabled then
                    		self.brakeSoundEnabled = false;
                	end;

                	if -self.input > 0.001 and not self.brakeSoundEnabled then
                    		if self:getIsActiveForSound() then
                        		playSample(self.brakeSound, 1, self.brakeSoundVolume, 0);
                        		setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
					self.motor.brakeForce = 50;
                    		end;
                    		self.brakeSoundEnabled = true;
			end;
                end;
            end;


    if self.isEntered then
       
	if self.handbrake then
		self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
		self.motor.brakeForce = 100;
   		self.brakelightsActive = true;		
	else

		if -self.input < -0.001 and self.movingDirection > 0 then
			self.brakelightsActive = true;
			self.motor.brakeForce = -self.input*-50;
		elseif -self.input > 0.001 and self.movingDirection < 0 then
    			self.brakelightsActive = true;
			self.motor.brakeForce = -self.input*25;
		else
			self.brakelightsActive = false;
			self.motor.brakeForce = 10;
		end;
		self.motor.backwardGearRatio = 1.5;
		self.motor.forwardGearRatios = {2, 2, 2};
	end;

	if self.kardan1Node ~= nil and self.kardan2Node ~= nil then
         	rotate(self.kardan1Node, self.motor.lastMotorRpm*0.01*self.movingDirection, 0, 0);
        	rotate(self.kardan2Node, self.motor.lastMotorRpm*0.01*self.movingDirection, 0, 0);
	end;

        if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
			self.light = not self.light;
	end;

		if self.light then
			setTextBold(true);
			setTextColor(0,1,0,1);
			renderText(0.804, 0.17, 0.026, "=");
			renderText(0.8, 0.172, 0.026, "(");
		else
			self.farlightsActive = false;
		end;

		if self.farlightsActive then
			for i=1, self.numFarlights do
				local farlight = self.farlights[i];
				setVisibility(farlight, self.farlightsActive);
				setTextColor(0,0,1,1);
				renderText(0.804, 0.17, 0.026, "=");
				renderText(0.8, 0.172, 0.026, "(");
			end;
		else
			for i=1, self.numFarlights	do
				local farlight = self.farlights[i];
				setVisibility(farlight, self.farlightsActive, false);
			end;
		end;

		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;

		if self.flashlightsLeftActive then
			for i=1, self.numFlashlightsLeft do
				local flashlightLeft = self.flashlightsLeft[i];
				setVisibility(flashlightLeft, self.flashlightsLeftActive);
			end;
		else
			for i=1, self.numFlashlightsLeft do
				local flashlightLeft = self.flashlightsLeft[i];
				setVisibility(flashlightLeft, self.flashlightsLeftActive, false);
			end;
		end;
	
		if self.flashlightsRightActive then
			for i=1, self.numFlashlightsRight do
				local flashlightRight = self.flashlightsRight[i];
				setVisibility(flashlightRight, self.flashlightsRightActive);
			end;
		else
			for i=1, self.numFlashlightsRight do
				local flashlightRight = self.flashlightsRight[i];
				setVisibility(flashlightRight, self.flashlightsRightActive, false);
			end;
		end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.flashlightsRightActive = true;
					self.flashlightsLeftActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.flashlightsLeftActive = false;
					self.flashlightsRightActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.flashlightsRightActive = false;
				self.flashlightsLeftActive = false;
			end;
		end;
		
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.flashlightsRightActive = false;
			end;
		end;

		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.flashlightLeftActive = false;
			end;
		end;
local doTranslate = self.translation1Max or self.translation1Min 
	if self.translation1 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end; 
local doTranslate = self.translation2Max or self.translation2Min 
	if self.translation2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translation2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2Max); 
		setTranslation(self.translation2.node, unpack(newTrans)); 
	end; 
		if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
       end;
    if self.rotationPartabl3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl3.maxRot, self.rotationPartabl3.minRot, 3, self.rotationPartabl3.rotTime, dt, not self.rotationMaxabl3);
		   setRotation(self.rotationPartabl3.node, unpack(newRot));
        end;
    if self.rotationPartabl4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl4.maxRot, self.rotationPartabl4.minRot, 3, self.rotationPartabl4.rotTime, dt, not self.rotationMaxabl4);
		   setRotation(self.rotationPartabl4.node, unpack(newRot));
  end;
    if self.rotationPartabl5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl5.maxRot, self.rotationPartabl5.minRot, 3, self.rotationPartabl5.rotTime, dt, not self.rotationMaxabl5);
		   setRotation(self.rotationPartabl5.node, unpack(newRot));    
 end;

	if not self.helpPanel then
		setTextBold(true);
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.17, 0.021, "~:Information");
	else
		setTextBold(true);
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.17, 0.021, "~:Information");
	end;
	if self.helpPanel then
		renderText(0.02, 0.50, 0.023, "KrAZ 7140 Edit by JAWA");
		renderText(0.02, 0.48, 0.021, "F/R: fenyszoro tompitott/tavolsagi");
		renderText(0.02, 0.46, 0.021, "SPACE: Rychnik");
		renderText(0.02, 0.44, 0.021, "F4: Avaryika");
		renderText(0.02, 0.42, 0.021, "F2/F3: Povorotniki");
		renderText(0.02, 0.40, 0.021, "5/6: Dveri");
		renderText(0.02, 0.38, 0.021, "7: Kapot");
		renderText(0.02, 0.36, 0.021, "8: Levoe Zerkalo");
		renderText(0.02, 0.34, 0.021, "9: Pravoe Zerkalo");
	end;

    end;

end;

function IFAL60:draw()

	if self.handbrake then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.input == -1 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "Take off with the parking brake!");
		end;
	end;



end;

function IFAL60:onEnter()

end;

function IFAL60:onLeave()

    self.farlightsActive = false;
    self.frontlightsActive = false;
    self.lightsActive = false;
    self.handbrake = false;
    self.brakelightsActive = false;
    self.handbrakelightsActive = false;
    self.helpPanel = false;
    self.cameras[self.camIndex]:onDeactivate();
    self.motor.brakeForce = 100;
    self.flashlightsRightActive = false;
    self.flashlightsLeftActive = false;
	for i=1, self.numFarlights	do
		local farlight = self.farlights[i];
		setVisibility(farlight, self.farlightsActive, false);
	end;
	for i=1, self.numbrakelights do
		local brakelight = self.brakelights[i];
		setVisibility(brakelight, self.brakelightsActive, false);
	end;
	for i=1, self.numFlashlightsLeft do
		local flashlightLeft = self.flashlightsLeft[i];
		setVisibility(flashlightLeft, self.flashlightsLeftActive, false);
	end;
	for i=1, self.numFlashlightsRight do
		local flashlightRight = self.flashlightsRight[i];
		setVisibility(flashlightRight, self.flashlightsRightActive, false);
	end;

end;