
moveSattelplatte = {};

function moveSattelplatte.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveSattelplatte:load(xmlFile)

	self.moveableSattelplatte = {};
	self.moveableSattelplatte.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableSattelplatte#index"));
	self.moveableSattelplatte.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableSattelplatte#maxZ"), 0); 
	self.moveableSattelplatte.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableSattelplatte#minZ"), 0); 
	
end;

function moveSattelplatte:delete()
end;

function moveSattelplatte:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveSattelplatte:keyEvent(unicode, sym, modifier, isDown)

end;

function moveSattelplatte:update(dt)

	if self.moveableSattelplatte ~= nil then
		local xSattelplatte, ySattelplatte, zSattelplatte = getTranslation(self.moveableSattelplatte.index);
		local maxZ = self.moveableSattelplatte.max;
		local minZ = self.moveableSattelplatte.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.Sattelplatte_Vor) then
				if zSattelplatte < maxZ then
					zSattelplatte = zSattelplatte + moveSpeed;
				else
					zSattelplatte = maxZ;
				end;
			elseif InputBinding.isPressed(InputBinding.Sattelplatte_Zuruek) then
				if zSattelplatte > minZ then
					zSattelplatte = zSattelplatte - moveSpeed;
				else
					zSattelplatte = minZ;
				end;
			end;
		setTranslation(self.moveableSattelplatte.index, xSattelplatte, ySattelplatte, zSattelplatte);
	end;
				
end;

function moveSattelplatte:onLeave()

end;

function moveSattelplatte:draw()

	if self.moveableSattelplatte then
		g_currentMission:addHelpButtonText(g_i18n:getText("Sattelplatte_Vor"), InputBinding.Sattelplatte_Vor);
		g_currentMission:addHelpButtonText(g_i18n:getText("Sattelplatte_Zuruek"), InputBinding.Sattelplatte_Zuruek);
	end;

end;

function moveSattelplatte:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

