--
-- Liftachse
-- Specialization for Trailer
-- Spezialisierung fr Anhnger
-- @ VWFahrer80
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.
Liftachse = {};

function Liftachse.prerequisitesPresent(specializations)
    return true;
end;

function Liftachse:load(xmlFile)
	self.autoDown = false;
	self.DownAllowed = false;
	self.LenkAchse = false;
	self.Verriegelung = false;
	self.VRTrigger = Liftachse.VRTrigger;
	self.VRTriggerIndex = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.vrtrigger#index"));
	addTrigger(self.VRTriggerIndex, "VRTrigger", self);
end;

function Liftachse:VRTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onStay then
		if InputBinding.hasEvent(InputBinding.Verriegelung) then
			self.Verriegelung = not self.Verriegelung;
		end;	
	end;
end;

function Liftachse:keyEvent(unicode, sym, modifier, isDown)
end;

function Liftachse:update(dt)
	if self.attacherVehicle ~= nil or not self.DownAllowed then
		self:setAnimationTime(1, self.animationParts[1].animDuration); --Fhrt Hoch
	end;
	if self.attacherVehicle == nil or self.autoDown or self.DownAllowed then 
		self:setAnimationTime(1, self.animationParts[1].offSet); --Fhrt Runter
	end;
	if self.fillLevel >= 25000 then
		self.autoDown = true;
		else
		self.autoDown = false;
	end;
	if self.fillLevel <= 25000 then 
		if InputBinding.hasEvent(InputBinding.Liftachse) then
			self.DownAllowed = not self.DownAllowed;
		end;	
		else
		self.DownAllowed = false;
	end;
	if self.attacherVehicle ~= nil then
		if self.LenkAchse then
			self:setAnimationTime(2, self.animationParts[2].animDuration); --Fhrt runter
			else
			self:setAnimationTime(2, self.animationParts[2].offSet); --Fhrt hoch
		end;
		else
		self:setAnimationTime(2, self.animationParts[2].animDuration); --Fhrt runter
	end;
	if self.fillLevel >= 1 then
		self.LenkAchse = true;
		else
		self.LenkAchse = false;
	end;
	if self.attacherVehicle ~= nil then
		self:setAnimationTime(3, self.animationParts[3].animDuration); --Fhrt Hoch
	end;
	if self.attacherVehicle == nil then 
		self:setAnimationTime(3, self.animationParts[3].offSet); --Fhrt Runter
	end;
	if self.Verriegelung then
		self:setAnimationTime(4, self.animationParts[4].animDuration); 
		else
		self:setAnimationTime(4, self.animationParts[4].offSet);
		self:onEndTip(true);
	end;
end;

function Liftachse:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function Liftachse:updateTick(dt)
end;

function Liftachse:draw()
	if self.DownAllowed then
		g_currentMission:addHelpButtonText(g_i18n:getText("Liftachse_hoch"), InputBinding.Liftachse);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Liftachse_runter"), InputBinding.Liftachse);
	end;
	if self.Verriegelung then
		g_currentMission:addHelpButtonText(g_i18n:getText("Closed_Lock"), InputBinding.Verriegelung);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Open_Lock"), InputBinding.Verriegelung);
	end;
end;

function Liftachse:readStream(streamId, connection)
end;

function Liftachse:writeStream(streamId, connection)
end;

function Liftachse:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Liftachse:delete()
end;

function Liftachse:onDetach()
end;