-- StrawFork
-- Specialization for forks used in the Straw Mod 09.
-- @ Bayn - www.tsforum3.com
-- @ date : 06/09/09


StrawFork = {};

function StrawFork.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function StrawFork:load(xmlFile)
	self.numAttachers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers#count"), 0);
	self.Attacher = {};
	
	for i=1, self.numAttachers do
	 self.Attacher[i] = {};
	 local partnamei = string.format("vehicle.Attachers.objectAttacher".."%d",i);
	 self.Attacher[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
	 self.Attacher[i].attachedObject = nil;
	 self.Attacher[i].objectInRange = nil;
	end;
	
end;

function StrawFork:delete()
			for i=1, self.numAttachers do
			ObjectDetachStrawFork(self,i)
			end;
end;

function StrawFork:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StrawFork:keyEvent(unicode, sym, modifier, isDown)
end;

function StrawFork:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.FORKDETACH) then
			-- dcrochage

			ObjectDetachStrawFork(self,1)
			ObjectDetachStrawFork(self,2)

		end;

		if InputBinding.isPressed(InputBinding.FORKATTACH) then
			-- dtection ballot
			for i=1, self.numAttachers do
				nearest, index = ObjectInRangeStrawFork(self,i);
				self.Attacher[i].objectInRange = nearest;
			end;
				-- accrochage
				ObjectAttachStrawFork(self,1)
				ObjectAttachStrawFork(self,2)

		end;
    end;
	
end;

function StrawFork:draw()
	if self.attacherVehicle ~= nil then
		if self.Attacher[1].attachedObject or self.Attacher[2].attachedObject then
			g_currentMission:addExtraPrintText(string.format("Touche %s: Detach bales", InputBinding.getButtonKeyName(InputBinding.FORKDETACH)));
		else
			g_currentMission:addExtraPrintText(string.format("Touche %s: Attach bales", InputBinding.getButtonKeyName(InputBinding.FORKATTACH)));
		end;
	end;
end;

function ObjectInRangeStrawFork(self,k)
	local nearestObject
	local itemNode
	local index 
	local nearestDistance = 0.5;
	local objectCopy = self.Attacher[k].object;	
	local px, py, pz = getWorldTranslation(objectCopy);
	for i=1, table.getn(g_currentMission.itemsToSave) do
	    itemNode = g_currentMission.itemsToSave[i].node;
	    if getParent(g_currentMission.itemsToSave[i].node) == getRootNode() then
			if getUserAttribute(itemNode, "isStrawbale") or getUserAttribute(itemNode, "isHaybale") then
				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					index = i
					nearestObject = itemNode
					nearestDistance = distance
					
				end;
			end;
		end;
	end;
	return nearestObject, index
end;

function ObjectAttachStrawFork(self,k)
	if self.Attacher[k].objectInRange ~= nil then
		if self.Attacher[k].attachedObject == nil then
			setRigidBodyType(self.Attacher[k].objectInRange,"none");
			local x,y,z = getWorldRotation(self.Attacher[k].objectInRange);		
			link(self.Attacher[k].object,self.Attacher[k].objectInRange);
			setRotation(self.Attacher[k].objectInRange, 0,0,0);
			setTranslation(self.Attacher[k].objectInRange, 0,0,0)
			self.Attacher[k].attachedObject = self.Attacher[k].objectInRange;
			self.Attacher[k].objectInRange = nil;
		end;
	end;
end;

function ObjectDetachStrawFork(self,k)
	if self.Attacher[k].attachedObject ~= nil then			
		local x,y,z = getWorldTranslation(self.Attacher[k].attachedObject)
		local rx,ry,rz = getWorldRotation(self.Attacher[k].attachedObject)
		local root = getRootNode()
		setTranslation(self.Attacher[k].attachedObject,x,y,z)
		setRotation(self.Attacher[k].attachedObject,rx,ry,rz)
		link(root,self.Attacher[k].attachedObject)
		setRigidBodyType(self.Attacher[k].attachedObject,"Dynamic")
		self.Attacher[k].attachedObject = nil;
	end;
end;