--
-- Kockschaufel
-- This is the specialization for Kockschaufel
--
-- M@D Author  Headshot XXL
-- M@D date 17.08.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Kockschaufel = {};

function Kockschaufel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Kockschaufel:load(xmlFile)

	self.moveDirection1 = 0;
	local rootNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
	self.animCharSet1 = 0;
	if rootNode1 ~= nil then
		self.animCharSet1 = getAnimCharacterSet(rootNode1);
		if self.animCharSet1 ~= 0 then
			local clip = getAnimClipIndex(self.animCharSet1, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			assignAnimTrackClip(self.animCharSet1, 0, clip);
			setAnimTrackLoopState(self.animCharSet1, 0, false);
			self.speedScale1 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
			self.animDuration1 = getAnimClipDuration(self.animCharSet1, clip);
		end;
	end;
		
	self.hydraulicSounds = {{}, {}};
    self.hydraulicSoundsEnabled = {{false,false}, {false,false}};
    local hydraulicUpSound = getXMLString(xmlFile, "vehicle.hydraulicUpSound#file");
    if hydraulicUpSound ~= nil and hydraulicUp ~= "" then
        hydraulicUpSound = Utils.getFilename(hydraulicUpSound, self.baseDirectory); 
        self.hydraulicSounds[1][1] = createSample("hydraulicUpSound");
        loadSample(self.hydraulicSounds[1][1], hydraulicUpSound, false);
        local pitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicUpSound#pitchOffset"), 0)
        setSamplePitch(self.hydraulicSounds[1][1], pitch);
    end;

    local hydraulicDownSound = getXMLString(xmlFile, "vehicle.hydraulicDownSound#file");
    if hydraulicDownSound ~= nil and hydraulicDownSound ~= "" then
        hydraulicDownSound = Utils.getFilename(hydraulicDownSound, self.baseDirectory); 
        self.hydraulicSounds[2][1] = createSample("hydraulicDownSound");
        loadSample(self.hydraulicSounds[2][1], hydraulicDownSound, false);
        local pitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicDownSound#pitchOffset"), 0)
        setSamplePitch(self.hydraulicSounds[2][1], pitch);
    end;

    local hydraulicTiltUpSound = getXMLString(xmlFile, "vehicle.hydraulicTiltUpSound#file");
    if hydraulicTiltUpSound ~= nil and hydraulicTiltUpSound ~= "" then
        hydraulicTiltUpSound = Utils.getFilename(hydraulicTiltUpSound, self.baseDirectory); 
        self.hydraulicSounds[1][2] = createSample("hydraulicTiltUpSound");
        loadSample(self.hydraulicSounds[1][2], hydraulicTiltUpSound, false);
        local pitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicTiltUpSound#pitchOffset"), 0)
        setSamplePitch(self.hydraulicSounds[1][2], pitch);
    end;

    local hydraulicTiltDownSound = getXMLString(xmlFile, "vehicle.hydraulicTiltDownSound#file");
    if hydraulicTiltDownSound ~= nil and hydraulicTiltDownSound ~= "" then
        hydraulicTiltDownSound = Utils.getFilename(hydraulicTiltDownSound, self.baseDirectory); 
        self.hydraulicSounds[2][2] = createSample("hydraulicTiltDownSound");
        loadSample(self.hydraulicSounds[2][2], hydraulicTiltDownSound, false);
        local pitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicTiltDownSound#pitchOffset"), 0)
        setSamplePitch(self.hydraulicSounds[2][2], pitch);
    end;

	self.isShovel = true;
	self.implementFallOut = false;

end;


function Kockschaufel:delete()

	for i=1, table.getn(self.hydraulicSounds) do
		for j=1, table.getn(self.hydraulicSounds[i]) do
			delete(self.hydraulicSounds[i][j]);
		end;
	end;

end;

function Kockschaufel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kockschaufel:keyEvent(unicode, sym, modifier, isDown)
end;

function Kockschaufel:update(dt)

	if self:getIsActiveForInput() then
		self.moveDirection1 = 0;
		if InputBinding.isPressed(InputBinding.KOCK_OPEN) then
			self.moveDirection1 = self.moveDirection1+1;
		elseif InputBinding.isPressed(InputBinding.KOCK_CLOSE) then
			self.moveDirection1 = self.moveDirection1-1;
		end;
    end;
	
	if self:getIsActive() then
	
		if self.animCharSet1 ~= 0 then
			local speedScale = nil;
			local playUp = false;
			local playDown = false;
			if self.moveDirection1 > 0.1 then
				speedScale = self.speedScale1;
				playUp = true;
			elseif self.moveDirection1 < -0.1 then
				speedScale = -self.speedScale1;
				playDown = true;
			end;
			if speedScale ~= nil then
				local animTrackTime = getAnimTrackTime(self.animCharSet1, 0);
				if speedScale > 0 then
					if animTrackTime < 0.0 then
						setAnimTrackTime(self.animCharSet1, 0, 0.0);
					elseif animTrackTime > self.animDuration1 then
						self.implementFallOut = true;
						playUp = false;
						playDown = false;
					end;
				else
					if animTrackTime > self.animDuration1 then
						setAnimTrackTime(self.animCharSet1, 0, self.animDuration1);
					elseif animTrackTime < 0.0 then
						self.implementFallOut = false;
						playUp = false;
						playDown = false;
					end;
				end;
				setAnimTrackSpeedScale(self.animCharSet1, 0, speedScale);
				enableAnimTrack(self.animCharSet1, 0);
				
				for i, jointDesc in pairs(self.componentJoints) do
				   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
				end;
			else
				disableAnimTrack(self.animCharSet1, 0);
			end;
			
			Kockschaufel.updateHydraulicSound(self, 1, i, playUp);
            Kockschaufel.updateHydraulicSound(self, 2, i, playDown);			
		end;
		
	end;

end;

function Kockschaufel:draw()

	g_currentMission:addExtraPrintText(g_i18n:getText("KOCK_1"));

end;

function Kockschaufel:onDetach()
    if self.deactivateOnDetach then
        Kockschaufel.onDeactivate(self);
    end;
end;

function Kockschaufel:onLeave()
    if self.deactivateOnLeave then
        Kockschaufel.onDeactivate(self);
    end;
end;

function Kockschaufel:onDeactivate()

	for i=1, 2 do
        Kockschaufel.updateHydraulicSound(self, 1, i, false);
        Kockschaufel.updateHydraulicSound(self, 2, i, false);
    end;
	if self.animCharSet1 ~= 0 then
		disableAnimTrack(self.animCharSet1, 0);
	end;

end;

function Kockschaufel.updateHydraulicSound(self, dirIndex, posIndex, play)
    local sound = self.hydraulicSounds[dirIndex][posIndex]
    if sound ~= nil then
        if play then
            if not self.hydraulicSoundsEnabled[dirIndex][posIndex] then
                if self:getIsActiveForSound() then
                    playSample(sound, 0, 1, 0);
                    self.hydraulicSoundsEnabled[dirIndex][posIndex] = true;
                end;
            end;
        else
            if self.hydraulicSoundsEnabled[dirIndex][posIndex] then
                stopSample(sound);
                self.hydraulicSoundsEnabled[dirIndex][posIndex] = false;
            end;
        end;
    end;
end;

