--
-- Kockflschaufel
-- This is the specialization for Kockflschaufel
--
-- M@D Author  Headshot XXL
-- M@D date 01.07.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Kockflschaufel = {};

function Kockflschaufel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Kockflschaufel:load(xmlFile)

	self.fallOut = false;
	self.fallOut2 = false;
	self.implementFallOut = true;
	self.isShovel = true;
end;


function Kockflschaufel:delete()
end;

function Kockflschaufel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kockflschaufel:keyEvent(unicode, sym, modifier, isDown)
end;

function Kockflschaufel:update(dt)

	if self.attacherVehicle ~= nil then
		self.fallOut2 = false;
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 1, 0));
		if z < 0 then
			self.fallOut = true;
		else
			self.fallOut = false;
		end;
		self.kippWinkel = z;
	end;
	
	if self.fallOut and self.implementFallOut then
		
		self:setFillLevel(self.fillLevel, self.currentFillType);
		
		local nearestDistance = 5.0;
		local px, py, pz = getWorldTranslation(self.tipReferencePoint);
		for i=1, table.getn(g_currentMission.attachables) do
			local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

			if distance < nearestDistance then
				local attachable = g_currentMission.attachables[i];		
				if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
					if self.currentFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
						if attachable.fillLevel < attachable.capacity  and self.fillLevel > 1 then							
							local deltaLevel = (self.kippWinkel*self.kippWinkel)*(self.capacity/200)*dt							
							local fillDelta = math.min(deltaLevel, self.fillLevel)
							--local fillDelta = self.fillLevel - currentFill;
							--self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
							--if self.fillLevel > 0 then
								self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
								attachable:setFillLevel(attachable.fillLevel + fillDelta, self.currentFillType);
							--end;
							self.fallOut2 = true;						
						end; 
					end;
				end;
			end;
		end;		
	end;
	
	Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.fallOut2);

end;

function Kockflschaufel:draw()
end;

function Kockflschaufel:onDetach()
    if self.deactivateOnDetach then
        Kockflschaufel.onDeactivate(self);
    end;
end;

function Kockflschaufel:onDeactivate()
    self.fallOut = false;
end;

