--
-- Teleskoplader
--
-- M@D Author  Headshot XXL
-- M@D date  29.04.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --


Teleskoplader = {}

function Teleskoplader.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Teleskoplader:load(xmlFile)

local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.rotationPartDrehzahl1 = {};
        self.rotationPartDrehzahl1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#minRot"));
        self.rotationPartDrehzahl1.minRot = {};
        self.rotationPartDrehzahl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#maxRot"));
        self.rotationPartDrehzahl1.maxRot = {};
        self.rotationPartDrehzahl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#rotTime"), 2)*1000;
        self.rotationPartDrehzahl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDrehzahl2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#index"));
    if rotationPartNodeDrehzahl2 ~= nil then
        self.rotationPartDrehzahl2 = {};
        self.rotationPartDrehzahl2.node = rotationPartNodeDrehzahl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#minRot"));
        self.rotationPartDrehzahl2.minRot = {};
        self.rotationPartDrehzahl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#maxRot"));
        self.rotationPartDrehzahl2.maxRot = {};
        self.rotationPartDrehzahl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#rotTime"), 2)*1000;
        self.rotationPartDrehzahl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#touchRotLimit"), 10));
    end;

local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;

	local rotationPartNodePedal = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartPedal#index"));
    if rotationPartNodePedal ~= nil then
        self.rotationPartPedal = {};
        self.rotationPartPedal.node = rotationPartNodePedal;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#minRot"));
        self.rotationPartPedal.minRot = {};
        self.rotationPartPedal.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#maxRot"));
        self.rotationPartPedal.maxRot = {};
        self.rotationPartPedal.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPedal.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#rotTime"), 2)*1000;
        self.rotationPartPedal.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#touchRotLimit"), 10));
    end;

local rotationPartNodeKmh1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh2#index"));
    if rotationPartNodeKmh2 ~= nil then
        self.rotationPartKmh2 = {};
        self.rotationPartKmh2.node = rotationPartNodeKmh2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#minRot"));
        self.rotationPartKmh2.minRot = {};
        self.rotationPartKmh2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#maxRot"));
        self.rotationPartKmh2.maxRot = {};
        self.rotationPartKmh2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#rotTime"), 2)*1000;
        self.rotationPartKmh2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#touchRotLimit"), 10));
    end;

local rotationPartNodeBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartBrake#index"));
    if rotationPartNodeBrake ~= nil then
        self.rotationPartBrake = {};
        self.rotationPartBrake.node = rotationPartNodeBrake;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#minRot"));
        self.rotationPartBrake.minRot = {};
        self.rotationPartBrake.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#maxRot"));
        self.rotationPartBrake.maxRot = {};
        self.rotationPartBrake.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartBrake.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#rotTime"), 2)*1000;
        self.rotationPartBrake.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#touchRotLimit"), 10));
    end;

	local translationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
    local translationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end; 

	local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
        self.rotation6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#touchRotLimit"), 10));
    end; 

	local rotationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#rotTime"), 2)*1000;
        self.rotation7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#touchRotLimit"), 10));
    end;       
	
	local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
        self.rotation8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#touchRotLimit"), 10));
    end;
	
	local rotationNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation9#index"));
    if rotationNode9 ~= nil then
        self.rotation9 = {};
        self.rotation9.node = rotationNode9;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#minRot"));
        self.rotation9.minRot = {};
        self.rotation9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#maxRot"));
        self.rotation9.maxRot = {};
        self.rotation9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation9#rotTime"), 2)*1000;
        self.rotation9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation9#touchRotLimit"), 10));
    end;

end;
      
function Teleskoplader:delete()    
end;

function Teleskoplader:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Teleskoplader:keyEvent(unicode, sym, modifier, isDown)

	local maxDrehzahl = 2250;
	if self.rotationPartDrehzahl1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl1.node);
		y = ((self.rotationPartDrehzahl1.maxRot[2] - self.rotationPartDrehzahl1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl1.minRot[2];
		setRotation(self.rotationPartDrehzahl1.node, x, y ,z);
	end;
	if self.rotationPartDrehzahl2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl2.node);
		y = ((self.rotationPartDrehzahl2.maxRot[2] - self.rotationPartDrehzahl2.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl2.minRot[2];
		setRotation(self.rotationPartDrehzahl2.node, x, y ,z);
																										end;
																		
      if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	
	if self.rotationPartTanknadel2 ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel2.node);
		y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
		setRotation(self.rotationPartTanknadel2.node, x, y ,z);
	end;

	local maxKmh = 50;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartKmh2 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh2.node);
		y = ((self.rotationPartKmh2.maxRot[2] - self.rotationPartKmh2.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh2.minRot[2];
		setRotation(self.rotationPartKmh2.node, x, y ,z);
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_up) then
			self.rotationMaxPedal = true;
		else
			self.rotationMaxPedal = false;
		end;
		if Input.isKeyPressed(Input.KEY_down) then
			self.rotationMaxBrake = true;
		else
			self.rotationMaxBrake = false;
		end;
		if self.gang0 then
			self.rotationMaxClutch = true;
		else
			self.rotationMaxClutch = false;
		end;
	end

	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_up) then
			self.rotationMaxPedal = true;
		else
			self.rotationMaxPedal = false;
		end;
		if Input.isKeyPressed(Input.KEY_down) then
			self.rotationMaxBrake = true;
		else
			self.rotationMaxBrake = false;
		end;
		if self.gang0 then
			self.rotationMaxClutch = true;
		else
			self.rotationMaxClutch = false;
		end;
	end
	


    if sym == Input.KEY_o then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_p then
		self.translationMin = isDown;
	end;

    if sym == Input.KEY_o then
		self.translationMax2 = isDown;
	end;
	if sym == Input.KEY_p then
		self.translationMin2 = isDown;
	end;

	if sym == Input.KEY_n then
		self.rotation9Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation9Min = isDown;
	end;
	if sym == Input.KEY_k then
		self.rotation8Max = isDown;
	end;
	if sym == Input.KEY_l then
		self.rotation8Min = isDown;
	end;
	if sym == Input.KEY_h then
		self.rotation7Max = isDown;
	end;
	if sym == Input.KEY_j then
		self.rotation7Min = isDown;
	end;
	if sym == Input.KEY_f then
		self.rotation6Max = isDown;
	end;
	if sym == Input.KEY_g then
		self.rotation6Min = isDown;
	end;

end;

function Teleskoplader:update(dt)

	local maxDrehzahl = 2250;
	if self.rotationPartDrehzahl1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl1.node);
		y = ((self.rotationPartDrehzahl1.maxRot[2] - self.rotationPartDrehzahl1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl1.minRot[2];
		setRotation(self.rotationPartDrehzahl1.node, x, y ,z);
	end;
	if self.rotationPartDrehzahl2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl2.node);
		y = ((self.rotationPartDrehzahl2.maxRot[2] - self.rotationPartDrehzahl2.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl2.minRot[2];
		setRotation(self.rotationPartDrehzahl2.node, x, y ,z);
																										end;
																		
      if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	
	if self.rotationPartTanknadel2 ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel2.node);
		y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
		setRotation(self.rotationPartTanknadel2.node, x, y ,z);
	end;

	local maxKmh = 50;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartKmh2 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh2.node);
		y = ((self.rotationPartKmh2.maxRot[2] - self.rotationPartKmh2.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh2.minRot[2];
		setRotation(self.rotationPartKmh2.node, x, y ,z);
	end;

	if self.rotationPartPedal ~= nil then
		local x, y, z = getRotation(self.rotationPartPedal.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPedal.maxRot, self.rotationPartPedal.minRot, 3, self.rotationPartPedal.rotTime, dt, not self.rotationMaxPedal);
		setRotation(self.rotationPartPedal.node, unpack(newRot));
	end;

     if self.rotationPartBrake ~= nil then
		local x, y, z = getRotation(self.rotationPartBrake.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartBrake.maxRot, self.rotationPartBrake.minRot, 3, self.rotationPartBrake.rotTime, dt, not self.rotationMaxBrake);
		setRotation(self.rotationPartBrake.node, unpack(newRot));
	end;

	local doTranslate = self.translationMax or self.translationMin 
	if self.translationPart ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax); 
		setTranslation(self.translationPart.node, unpack(newTrans)); 
	end; 
	local doTranslate = self.translationMax2 or self.translationMin2 
	if self.translationPart2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2); 
		setTranslation(self.translationPart2.node, unpack(newTrans)); 
	end;

	local doRotate = self.rotation6Max or self.rotation6Min 
	if self.rotation6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6Max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;

	local doRotate = self.rotation7Max or self.rotation7Min 
	if self.rotation7 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7Max);
        setRotation(self.rotation7.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation8Max or self.rotation8Min 
	if self.rotation8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation9Max or self.rotation9Min 
	if self.rotation9 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation9.maxRot, self.rotation9.minRot, 3, self.rotation9.rotTime, dt, not self.rotation9Max);
        setRotation(self.rotation9.node, unpack(newRot));
    end;

end;

function Teleskoplader:draw()
end;

function Teleskoplader:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
