--KAMAZ
-- M@D Author  StarT  gswlad
-- M@D date  15.3.2012

KAMAZ = {};

function KAMAZ.prerequisitesPresent(specializations)
    return true ;
end;

function KAMAZ:load(xmlFile)

	--self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {}
	self.collisionArm = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		--self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		--[[if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; ]]
	end;


end;

function KAMAZ:delete()

end;

function KAMAZ:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KAMAZ:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym==Input.KEY_space then
		self.Go.pillar = not self.Go.pillar; 
		self.Done.pillar = true;
	end;

	if isDown and sym==Input.KEY_KP_plus then
		self.Go.pillars = not self.Go.pillars; 
		self.Done.pillars = true;
	end;

	if isDown and sym==Input.KEY_8 then
		self.Go.pillarse = not self.Go.pillarse; 
		self.Done.pillarse = true;
	end;

	if isDown and sym==Input.KEY_7 then
		self.Go.pillarsen = not self.Go.pillarsen; 
		self.Done.pillarsen = true;
	end;

	if isDown and sym==Input.KEY_6 then
		self.Go.pillarsena = not self.Go.pillarsena; 
		self.Done.pillarsena = true;
	end;

	if isDown and sym==Input.KEY_5 then
		self.Go.pillarsenar = not self.Go.pillarsenar; 
		self.Done.pillarsenar = true;
	end;

	if isDown and sym == 96 then
        	self.helpPanel = not self.helpPanel;
    	end;

end;

function KAMAZ:update(dt)


	if self.Go.pillar ~= nil and self.Done.pillar ~= false then
		self:anim("pillar", false); 
	end; 

	if self.Go.pillars ~= nil and self.Done.pillars ~= false then
		self:anim("pillars", false); 
	end; 

	if self.Go.pillarse ~= nil and self.Done.pillarse ~= false then
		self:anim("pillarse", false); 
	end;

	if self.Go.pillarsen ~= nil and self.Done.pillarsen ~= false then
		self:anim("pillarsen", false); 
	end;

	if self.Go.pillarsena ~= nil and self.Done.pillarsena ~= false then
		self:anim("pillarsena", false); 
	end;

	if self.Go.pillarsenar ~= nil and self.Done.pillarsenar ~= false then
		self:anim("pillarsenar", false); 
	end;

    if self.isEntered then

	self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	end;

    end;

end;

function KAMAZ:draw()

end;

function KAMAZ:onEnter()

end;

function KAMAZ:onLeave()


end;

function KAMAZ:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 


--[[function KAMAZ:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;]]
