--
-- class for tueren
--
-- Author Sebastian B. (Blancker, www.landwirtschaftssimulator-2009.de)
--
-- Date  08.08.2009
--
-- Copyright (C) Blancker
-- Edit by Mario


tueren = {}

function tueren.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function tueren:load(xmlFile)        
	
	-- Anfang Left
	
	local rotationPartNodeleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.left#index"));
    if rotationPartNodeleft ~= nil then
        self.rotationPartleft = {};
        self.rotationPartleft.node = rotationPartNodeleft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleft#minRot"));
        self.rotationPartleft.minRot = {};
        self.rotationPartleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.left#maxRot"));
        self.rotationPartleft.maxRot = {};
        self.rotationPartleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#rotTime"), 2)*1000;
        self.rotationPartleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#touchRotLimit"), 10));
    end;
	
	-- Ende Left
	
	
		-- Anfang forward
	
	local rotationPartNodeforward = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.forward#index"));
    if rotationPartNodeforward ~= nil then
        self.rotationPartforward = {};
        self.rotationPartforward.node = rotationPartNodeforward;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartforward#minRot"));
        self.rotationPartforward.minRot = {};
        self.rotationPartforward.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartforward.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartforward.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.forward#maxRot"));
        self.rotationPartforward.maxRot = {};
        self.rotationPartforward.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartforward.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartforward.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartforward.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.forward#rotTime"), 2)*1000;
        self.rotationPartforward.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.forward#touchRotLimit"), 10));
    end;
	
	-- Ende forward
	
	
	
	
	
	
	-- Anfang Right
	
	local rotationPartNoderight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.right#index"));
    if rotationPartNoderight ~= nil then
        self.rotationPartright = {};
        self.rotationPartright.node = rotationPartNoderight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartright#minRot"));
        self.rotationPartright.minRot = {};
        self.rotationPartright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.right#maxRot"));
        self.rotationPartright.maxRot = {};
        self.rotationPartright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#rotTime"), 2)*1000;
        self.rotationPartright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#touchRotLimit"), 10));
    end;

	-- Ende Right
	
	-- Anfang Animation Left
	
	local rotationPartNodealeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aleft#index"));
    if rotationPartNodealeft ~= nil then
        self.rotationPartaleft = {};
        self.rotationPartaleft.node = rotationPartNodealeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaleft#minRot"));
        self.rotationPartaleft.minRot = {};
        self.rotationPartaleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aleft#maxRot"));
        self.rotationPartaleft.maxRot = {};
        self.rotationPartaleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aleft#rotTime"), 2)*1000;
        self.rotationPartaleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aleft#touchRotLimit"), 10));
    end;
	
	-- Ende Animation Left
	
	
	-- Anfang Animation forward
	
	local rotationPartNodeaforward = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aforward#index"));
    if rotationPartNodeaforward ~= nil then
        self.rotationPartaforward = {};
        self.rotationPartaforward.node = rotationPartNodeaforward;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaforward#minRot"));
        self.rotationPartaforward.minRot = {};
        self.rotationPartaforward.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaforward.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaforward.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aforward#maxRot"));
        self.rotationPartaforward.maxRot = {};
        self.rotationPartaforward.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaforward.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaforward.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaforward.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aforward#rotTime"), 2)*1000;
        self.rotationPartaforward.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aforward#touchRotLimit"), 10));
    end;
	
	-- Ende Animation forward
	
	
	
	-- Anfang Animation Right
	
	local rotationPartNodearight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aright#index"));
    if rotationPartNodearight ~= nil then
        self.rotationPartaright = {};
        self.rotationPartaright.node = rotationPartNodearight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaright#minRot"));
        self.rotationPartaright.minRot = {};
        self.rotationPartaright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aright#maxRot"));
        self.rotationPartaright.maxRot = {};
        self.rotationPartaright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aright#rotTime"), 2)*1000;
        self.rotationPartaright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aright#touchRotLimit"), 10));
    end;

	-- Ende Animation Right
end;
      
function tueren:delete()    
end;

function tueren:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function tueren:keyEvent(unicode, sym, modifier, isDown)
	
	-- Anfang Left
	
	if isDown and sym == Input.KEY_n then 
		self.rotationMaxleft = not self.rotationMaxleft;
		self.rotationMaxaleft = not self.rotationMaxaleft;
	end;
	
	-- Ende Left
	
	
	-- Anfang forward
	
	if isDown and sym == Input.KEY_l then 
		self.rotationMaxforward = not self.rotationMaxforward;
		self.rotationMaxaforward = not self.rotationMaxaforward;
	end;
	
	-- Ende forward
	
	
	
	
	
	
	
	
	
	
	
	-- Anfang Right
	
	if isDown and sym == Input.KEY_m then 
		self.rotationMaxright = not self.rotationMaxright;
		self.rotationMaxaright = not self.rotationMaxaright;
	end;
	
	-- Ende Right
	
	-- Anfang Info
	
	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
	
	-- Ende Info
	
end;

function tueren:update(dt)
	
	-- Anfang Left
	
	if self.rotationPartleft ~= nil then
		local x, y, z = getRotation(self.rotationPartleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleft.maxRot, self.rotationPartleft.minRot, 3, self.rotationPartleft.rotTime, dt, not self.rotationMaxleft);
		setRotation(self.rotationPartleft.node, unpack(newRot));
	end;
	
	-- Ende Left
	
	
	
	-- Anfang forward 
	
	if self.rotationPartforward  ~= nil then
		local x, y, z = getRotation(self.rotationPartforward .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartforward.maxRot, self.rotationPartforward.minRot, 3, self.rotationPartforward.rotTime, dt, not self.rotationMaxforward);
		setRotation(self.rotationPartforward .node, unpack(newRot));
	end;
	
	-- Ende forward 
	
	
	
	-- Anfang Right
	
	if self.rotationPartright ~= nil then
		local x, y, z = getRotation(self.rotationPartright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartright.maxRot, self.rotationPartright.minRot, 3, self.rotationPartright.rotTime, dt, not self.rotationMaxright);
		setRotation(self.rotationPartright.node, unpack(newRot));
   end;

	-- Ende Right
	
	-- Anfang Animation Left
	
	if self.rotationPartaleft ~= nil then
		local x, y, z = getRotation(self.rotationPartaleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaleft.maxRot, self.rotationPartaleft.minRot, 3, self.rotationPartaleft.rotTime, dt, not self.rotationMaxaleft);
		setRotation(self.rotationPartaleft.node, unpack(newRot));
	end;
	
	-- Ende Animation Left
	
	-- Anfang Animation forward 
	
	if self.rotationPartaforward  ~= nil then
		local x, y, z = getRotation(self.rotationPartaforward .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaforward .maxRot, self.rotationPartaforward .minRot, 3, self.rotationPartaforward .rotTime, dt, not self.rotationMaxaforward);
		setRotation(self.rotationPartaforward .node, unpack(newRot));
	end;
	
	-- Ende Animation forward 
	
	
	-- Anfang Animation Right
	
	if self.rotationPartaright ~= nil then
		local x, y, z = getRotation(self.rotationPartaright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaright.maxRot, self.rotationPartaright.minRot, 3, self.rotationPartaright.rotTime, dt, not self.rotationMaxaright);
		setRotation(self.rotationPartaright.node, unpack(newRot));
	end;

	-- Ende Animation Right
	
end;

function tueren:onLeave()
	
	-- Anfang Left
	
    self.rotationMaxleft = false;
	
	-- Ende Left
	
	
	-- Anfang forward 
	
    self.rotationMaxforward  = false;
	
	-- Ende forward 
	
	
	
	
	-- Anfang Right
	
	self.rotationMaxright = false;
	
	-- Ende Right
	
	-- Anfang Animation Left
	
    self.rotationMaxaleft = false;
	
	-- Ende Animation Left
	
	
	-- Anfang Animation forward 
	
    self.rotationMaxaforward  = false;
	
	-- Ende Animation forward 
	
	
	-- Anfang Animation Right
	
	self.rotationMaxaright = false;
	
	-- Ende Animation Right
end;
function tueren:draw()

	if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, "Taste 0: Info AUS");
		else
			renderText(0.8335, 0.17, 0.02, "Taste 0: Info AN");
		end;
		if self.helpPanel then
			renderText(0.72, 0.88, 0.025, "- KAMAZ -");
			renderText(0.72, 0.84, 0.02, "Taste M: DVER-1");
			renderText(0.72, 0.82, 0.02, "Taste N: DVER-2");
			renderText(0.72, 0.80, 0.02, "");
			renderText(0.72, 0.78, 0.02, "");
			
			
			renderText(0.72, 0.80, 0.02, "");
			
	end;
	
end;

