

KZK10 = {};

function KZK10.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Sprayer, specializations) ;
end;

function KZK10:load(xmlFile)
	self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel; 
	self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;	
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		if self.hydraulics[i].punch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	local StopPNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.StopP#index"));
    if StopPNode ~= nil then
        self.StopP = {};
        self.StopP.node = StopPNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.StopP#minRot"));
        self.StopP.minRot = {};
        self.StopP.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.StopP.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.StopP.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.StopP#maxRot"));
        self.StopP.maxRot = {};
        self.StopP.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.StopP.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.StopP.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.StopP.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.StopP#rotTime"), 2)*1000;
        self.StopP.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.StopP#touchRotLimit"), 10));
	
    end;	
	local StopLNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.StopL#index"));
    if StopPNode ~= nil then
        self.StopL = {};
        self.StopL.node = StopLNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.StopL#minRot"));
        self.StopL.minRot = {};
        self.StopL.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.StopL.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.StopL.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.StopL#maxRot"));
        self.StopL.maxRot = {};
        self.StopL.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.StopL.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.StopL.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.StopL.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.StopL#rotTime"), 2)*1000;
        self.StopL.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.StopL#touchRotLimit"), 10));
    end;
	local SupportAttacherNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SupportAttacher#index"));
    if SupportAttacherNode ~= nil then
        self.SupportAttacher = {};
        self.SupportAttacher.node = SupportAttacherNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportAttacher#minTrans"));
        self.SupportAttacher.minTrans = {};
        self.SupportAttacher.minTrans[1] = Utils.getNoNil(x, 0);
        self.SupportAttacher.minTrans[2] = Utils.getNoNil(y, 0);
        self.SupportAttacher.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportAttacher#maxTrans"));
        self.SupportAttacher.maxTrans = {};
        self.SupportAttacher.maxTrans[1] = Utils.getNoNil(x, 0);
        self.SupportAttacher.maxTrans[2] = Utils.getNoNil(y, 0);
        self.SupportAttacher.maxTrans[3] = Utils.getNoNil(z, 0);

        self.SupportAttacher.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportAttacher#transTime"), 2)*1000;
        self.SupportAttacher.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportAttacher#touchTransLimit"), 10);
    end;	
	local SupportFrameNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SupportFrame#index"));
    if SupportFrameNode ~= nil then
        self.SupportFrame = {};
        self.SupportFrame.node = SupportFrameNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportFrame#minRot"));
        self.SupportFrame.minRot = {};
        self.SupportFrame.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.SupportFrame.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.SupportFrame.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.SupportFrame#maxRot"));
        self.SupportFrame.maxRot = {};
        self.SupportFrame.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.SupportFrame.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.SupportFrame.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.SupportFrame.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportFrame#rotTime"), 2)*1000;
        self.SupportFrame.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.SupportFrame#touchRotLimit"), 10));
    end;
	self.numRollers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Rollers#count"), 0);	
    self.Rollers = {};
    for i=1, self.numRollers do
        local Rollersnamei = string.format("vehicle.Rollers.Roller" .. "%d", i);
        self.Rollers[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, Rollersnamei .. "#index"));
    end;	
	self.CarrierWorkingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.CarrierWorkingParticleSystems.CarrierWorkingParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.CarrierWorkingParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.SupportAttacherMin = true;
	self.SupportFrameMin = true;
	
end;

function KZK10:delete()
end;

function KZK10:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KZK10:keyEvent(unicode, sym, modifier, isDown)
end;

function KZK10:update(dt)
	if self:getIsActive() then
		
		for i=1, table.getn(self.hydraulics) do
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
			setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].doScale then
				local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
				local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
				setScale(self.hydraulics[i].punch, 1, 1, newScale);
			else
				if self.hydraulics[i].punch ~= nil then
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				else
					setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
				end;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.CARRIERSUPPORT)  then
			self.SupportAttacherMax = not self.SupportAttacherMax;
			self.SupportFrameMax = not self.SupportFrameMax;
		end;
		
		if InputBinding.hasEvent(InputBinding.ROLLERISDOWN)  then
			self.RollerIsDown = not self.RollerIsDown;
		end;
		if self.RollerIsDown then
			for i=1, self.numRollers do
				local Roller = self.Rollers[i];
				rotate(Roller,0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
			end;
			if self.lastSpeed*3600 > 9  then
				Utils.setEmittingState(self.CarrierWorkingParticleSystems, true)				
			end;
			if self.lastSpeed*3600 < 9  then
				Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)			
			end;
			else
				Utils.setEmittingState(self.CarrierWorkingParticleSystems, false)			
		end;		
		local doTranslate = self.SupportAttacherMax or self.SupportAttacherMin or not self.SupportAttacherMax
		if self.SupportAttacher ~= nil and doTranslate then	
			local x, y, z = getTranslation(self.SupportAttacher.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.SupportAttacher.maxTrans, self.SupportAttacher.minTrans, 3, self.SupportAttacher.transTime, dt, not self.SupportAttacherMax);
			setTranslation(self.SupportAttacher.node, unpack(newTrans));
		end;
		local doRotate = self.SupportFrameMax or self.SupportFrameMin or not self.SupportFrameMax
		if self.SupportFrame ~= nil and doRotate then	
			local x, y, z = getRotation(self.SupportFrame.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.SupportFrame.maxRot, self.SupportFrame.minRot, 3, self.SupportFrame.rotTime, dt, not self.SupportFrameMax);
			setRotation(self.SupportFrame.node, unpack(newRot));
		end;
			setJointFrame(self.componentJoints[3].jointIndex, 1,self.componentJoints[3].jointNode);				
	end;
end;

function KZK10:updateTick(dt)

end;

function KZK10:draw()
    g_currentMission:addExtraPrintText(string.format("Support Open/Close %s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.CARRIERSUPPORT)));
end;

function KZK10:onDetach()
end;

function KZK10:onLeave()
end;

function KZK10:onDeactivate()
end;