
SetConditionerOnEvent = {};
SetConditionerOnEvent_mt = Class(SetConditionerOnEvent, Event);
  
InitEventClass(SetConditionerOnEvent, "SetConditionerOnEvent");
  
function SetConditionerOnEvent:emptyNew()
     local self = Event:new(SetConditionerOnEvent_mt);
      self.className="SetConditionerOnEvent";
      return self;
end;
  
function SetConditionerOnEvent:new(object, condtionerOn)
      local self = SetConditionerOnEvent:emptyNew()
      self.object = object;
      self.condtionerOn = condtionerOn;
      return self;
end;
  
function SetConditionerOnEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.condtionerOn = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetConditionerOnEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.condtionerOn);
end;
  
function SetConditionerOnEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setConditionerOn(self.condtionerOn, true);
end;
  
function SetConditionerOnEvent.sendEvent(vehicle, condtionerOn, noEventSend)
      if condtionerOn ~= vehicle.isConditionerOn then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetConditionerOnEvent:new(vehicle, condtionerOn), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetConditionerOnEvent:new(vehicle, condtionerOn));
              end;
          end;
      end;
end;