--
-- 
-- 
--
-- @author Acid_Burn84

--
-- Copyright (C) by Acid_Burn84

Krone = {};

function Krone.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Krone:load(xmlFile)

    self.setFillLevel = SpecializationUtil.callSpecializationsFunction("setFillLevel");

	self.numExtensions = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extensions#count"), 0);
    self.extensions = {};
    for i=1, self.numExtensions do
        local extensionnamei = string.format("vehicle.extensions.extension" .. "%d", i);
        self.extensions[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, extensionnamei .. "#index"));
        setVisibility(self.extensions[i], false);
    end;

	self.capacity1 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
	self.capacity2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity2"), 0.0);
	self.extend = true;


-- Small Grainplane
    self.grainPlanes1 = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.grainPlane1.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            setVisibility(node, false);
            if self.defaultGrainPlane1 == nil then
                self.defaultGrainPlane1 = node;
            end;
            self.grainPlanes1[t] = node;
        end;
        i = i +1;
    end;
    if self.defaultGrainPlane1==nil then
        self.grainPlanes1 = nil;
    end;

    self.grainPlane1MinY, self.grainPlane1MaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainPlane1#minMaxY"));
    if self.grainPlane1MinY == nil or self.grainPlane1MaxY == nil then
        local grainAnimCurve1 = AnimCurve:new(linearInterpolator4);
        local keyI = 0;
        while true do
            local key = string.format("vehicle.grainPlane1.key(%d)", keyI);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            grainAnimCurve1:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            keyI = keyI +1;
        end;
        if keyI > 0 then
            self.grainAnimCurve1 = grainAnimCurve1;
        end;
        self.grainPlane1MinY = 0;
        self.grainPlane1MaxY = 0;
    end;

end;

function Krone:delete()
end;

function Krone:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Krone:keyEvent(unicode, sym, modifier, isDown)
	if self.fillLevel < self.capacity1 then
		if isDown and sym == Input.KEY_b then
			self.extend = not self.extend;
		end;
	end;
end;


function Krone:update(dt)
      
	if self.attacherVehicle then
		if self.extend then
			self.capacity = self.capacity2
			self.extensionsActive = true;
		else
			self.capacity = self.capacity1;
			self.extensionsActive = false;
		end;
	end;
	
	if self.extensionsActive then
		for i=1, self.numExtensions do
			local extension = self.extensions[i];
			setVisibility(extension, self.extensionsActive);
		end;
	else
		for i=1, self.numExtensions do
			local extension = self.extensions[i];
			setVisibility(extension, self.extensionsActive, false);
		end;
	end;
   
end;

function Krone:setFillLevel(fillLevel, fillType)
    if not self:allowFillType(fillType, false) then
        return;
    end;

    self.currentFillType = fillType;
    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
        -- reset fill type as the trailer is empty
        Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], false);
        self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
    end;

-- Small Grainplane
	if not self.extensionsActive then
    if self.currentGrainPlane ~= nil then
        setVisibility(self.currentGrainPlane, false);
    end;
    if self.grainPlanes1 ~= nil and self.defaultGrainPlane1 ~= nil and fillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fillTypeName = FruitUtil.fruitIndexToDesc[fillType].name;
        local grainPlane = self.grainPlanes1[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainPlane1;
        end;
        local yTranslation;
        if self.grainAnimCurve1 then
            local scaleX, scaleY, scaleZ , yTrans = self.grainAnimCurve1:get(self.fillLevel/self.capacity);
            yTranslation = yTrans;
            setScale(grainPlane, scaleX, scaleY, scaleZ);
        else
            local m = (self.grainPlaneMaxY - self.grainPlaneMinY) / self.capacity;
            yTranslation = m*self.fillLevel + self.grainPlaneMinY;
        end;
        local xPos, yPos, zPos = getTranslation(grainPlane);
        setTranslation(grainPlane, xPos, yTranslation, zPos);
        setVisibility(grainPlane, self.fillLevel > 0);
        self.currentGrainPlane = grainPlane;
end;
end;
-- Normal Grainplane
if  self.extensionsActive then
    if self.currentGrainPlane ~= nil then
        setVisibility(self.currentGrainPlane, false);
    end;
    if self.grainPlanes ~= nil and self.defaultGrainPlane ~= nil and fillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fillTypeName = FruitUtil.fruitIndexToDesc[fillType].name;
        local grainPlane = self.grainPlanes[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainPlane1;
        end;
        local yTranslation;
        if self.grainAnimCurve then
            local scaleX, scaleY, scaleZ , yTrans = self.grainAnimCurve:get(self.fillLevel/self.capacity);
            yTranslation = yTrans;
            setScale(grainPlane, scaleX, scaleY, scaleZ);
        else
            local m = (self.grainPlaneMaxY - self.grainPlaneMinY) / self.capacity;
            yTranslation = m*self.fillLevel + self.grainPlaneMinY;
        end;
        local xPos, yPos, zPos = getTranslation(grainPlane);
        setTranslation(grainPlane, xPos, yTranslation, zPos);
        setVisibility(grainPlane, self.fillLevel > 0);
        self.currentGrainPlane = grainPlane;
end;

    end;
end;

function Krone:draw()

end;
