

Anhaengerbetrieb = {};

function Anhaengerbetrieb.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Anhaengerbetrieb:load(xmlFile)
    
     self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.worklightsActive = false;

end;

function Anhaengerbetrieb:delete()
end;

function Anhaengerbetrieb:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Anhaengerbetrieb:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_9 then
		self.worklightsActive = not self.worklightsActive;
	end;
end;

function Anhaengerbetrieb:update(dt)

   
   if self.isEntered then
   if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
end;


function Anhaengerbetrieb:onLeave()

	
	self.worklightsActive = false;

end;


function Anhaengerbetrieb:draw()


if self.isEntered then
    if self.worklightsActive then
        g_currentMission:addExtraPrintText("Taste 9: Anhaengerbetrieblicht ausschalten");
   else
        g_currentMission:addExtraPrintText("Taste 9: Anhaengerbetrieblicht anschalten");
   end;
end;
end;