--
-- JD 3765 Forage Harvestor
-- LS_UK Modteam
-- 25/05/2011
-- www.ls-uk.info

JDDrawbar = {};

function JDDrawbar.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function JDDrawbar:load(xmlFile)

	self.setRotationDrawbar = SpecializationUtil.callSpecializationsFunction("setRotationDrawbar");


	local rotationDrawbarNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationDrawbar#index"));
		if rotationDrawbarNode ~= nil then
        self.rotationDrawbar = {};
        self.rotationDrawbar.node = rotationDrawbarNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationDrawbar#minRot"));
        self.rotationDrawbar.minRot = {};
        self.rotationDrawbar.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationDrawbar.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationDrawbar.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationDrawbar#maxRot"));
        self.rotationDrawbar.maxRot = {};
        self.rotationDrawbar.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationDrawbar.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationDrawbar.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationDrawbar.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationDrawbar#rotTime"), 2)*1000;
        self.rotationDrawbar.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationDrawbar#touchRotLimit"), 10));
    end;
	
	self.rotationDrawbarMax = false;	
	
	self.pto = {};
	self.pto[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pto#index1"));
	self.pto[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pto#index2"));
	
	setVisibility(self.pto[1], false);
	setVisibility(self.pto[2], true); 
	
    self.hudInfoBasePosX = 0;
    self.hudInfoBaseWidth = 0.1;
    self.hudInfoBasePosY = 0.26;
    self.hudInfoBaseHeight = 0.5;
    self.infoPanelPath = Utils.getFilename("textures/JD3765_menu.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    self.showHudInfoBase = false;
end;

function JDDrawbar:readStream(streamId, connection)
     self.rotateDrawbar = streamReadBool(streamId);
      if self.rotationDrawbar ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationDrawbar.node, x, y, z);
      end;

end;

function JDDrawbar:writeStream(streamId, connection)
	streamWriteBool(streamId, self.rotateDrawbar);
		if self.rotationDrawbar ~= nil then
          local x, y, z = getRotation(self.rotationDrawbar.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function JDDrawbar:delete()

end;

function JDDrawbar:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JDDrawbar:keyEvent(unicode, sym, modifier, isDown)

		if isDown and sym == Input.KEY_KP_enter then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;

end;

function JDDrawbar:update(dt)

      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setRotationDrawbar(not self.rotationDrawbarMax);
          end;
     end;
end;

function JDDrawbar:updateTick(dt)
	if self:getIsActive() then
	if self.rotationDrawbar ~= nil then
        local x, y, z = getRotation(self.rotationDrawbar.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationDrawbar.maxRot, self.rotationDrawbar.minRot, 3, self.rotationDrawbar.rotTime, dt, not self.rotationDrawbarMax);
        setRotation(self.rotationDrawbar.node, unpack(newRot));
    end;
	end;
	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function JDDrawbar:draw()
		if self.showHudInfoBase then	
			g_currentMission:addExtraPrintText("Key KP Enter:                                   Menu Off");
		else
			g_currentMission:addExtraPrintText("Key KP Enter:                                   Menu On");
		end;

		if self.showHudInfoBase then
			self.hudInfoBaseOverlay:render();
		end;
end;

function JDDrawbar:onDetach()
	setVisibility(self.pto[1], false);
	setVisibility(self.pto[2], true);
end;

function JDDrawbar:onAttach(attacherVehicle)
	setVisibility(self.pto[1], true);
	setVisibility(self.pto[2], false);
end;

function JDDrawbar:setRotationDrawbar(rotationDrawbarMax, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetRotationEventDrawbar:new(self, rotationDrawbarMax), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetRotationEventDrawbar:new(self, rotationDrawbarMax));
          end;
      end;
      self.rotationDrawbarMax = rotationDrawbarMax;
end;

function JDDrawbar:validateAttacherJoint(implement, jointDesc, dt)
   return true;
end;

function JDDrawbar:attachImplement(implement)
	
end

SetRotationEventDrawbar = {};
SetRotationEventDrawbar_mt = Class(SetRotationEventDrawbar, Event);
 
InitEventClass(SetRotationEventDrawbar, "SetRotationEventDrawbar");

function SetRotationEventDrawbar:emptyNew()
      local self = Event:new(SetRotationEventDrawbar_mt);
      self.className="SetRotationEventDrawbar";
      return self;
end;
 
function SetRotationEventDrawbar:new(object, rotationDrawbarMax)
     local self = SetRotationEventDrawbar:emptyNew()
     self.object = object;
     self.rotationDrawbarMax = rotationDrawbarMax;
      return self;
end;

function SetRotationEventDrawbar:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationDrawbarMax = streamReadBool(streamId);
     self.object = networkGetObject(id);
      self:run(connection);
end;
 
function SetRotationEventDrawbar:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationDrawbarMax);
end;

function SetRotationEventDrawbar:run(connection)
     self.object:setRotationDrawbar(self.rotationDrawbarMax, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetRotationEventDrawbar:new(self.object, self.rotationDrawbarMax), nil, connection, self.object);
     end;
end;