--

pickupGrassSwads = {};

function pickupGrassSwads.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function pickupGrassSwads:load(xmlFile)

    self.speedLimit = 27.5;
    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"),1);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    self.cuttingAreas = nil;
    self.cuttingAreas = {};
    self.cuttingAreasN = {};
    for i=1, numCuttingAreas do
        self.cuttingAreasN[i] = {};
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreasN[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasN[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasN[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
self.speedRotatingParts = {};
     local i=0;
     while true do
          local baseName = string.format("vehicle.speedRotatingParts.speedRotatingPart(%d)", i);
          local index = getXMLString(xmlFile, baseName.. "#index");
          if index == nil then
              break;
          end;
          local node = Utils.indexToObject(self.components, index);
          if node ~= nil then
              local entry = {};
              entry.node = node;
              entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
              if entry.rotationSpeedScale == nil then
                  entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
              end;
  
              entry.rotateOnGroundContact = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#rotateOnGroundContact"), false);
  
              entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
              entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
  
              table.insert(self.speedRotatingParts, entry);
          end;
          i = i+1;
      end;
	  
      self.lastArea = 0;
      self.lastAreaBiggerZero = self.lastArea > 0;
end;

function pickupGrassSwads:delete()

end;

function pickupGrassSwads:readStream(streamId, connection)
end;

function pickupGrassSwads:writeStream(streamId, connection)
	
end;

function pickupGrassSwads:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pickupGrassSwads:keyEvent(unicode, sym, modifier, isDown)

end;

function pickupGrassSwads:update(dt)
      Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastAreaBiggerZero));		

end;

function pickupGrassSwads:updateTick(dt)
	--if self.reelStarted then
	if self.reelStarted and self.movingDirection < 0 then
        local hasGroundContact = false;
        local x,y,z = getWorldTranslation(self.groundReferenceNode);
        local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
        if terrainHeight+self.groundReferenceThreshold >= y then
            hasGroundContact = true;
        end;
		if hasGroundContact then
			local realArea = 0;
			for k,area in pairs(self.cuttingAreasN) do
				for fruitType,v in pairs(self.fruitTypes) do
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);
					
					local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
					area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
					if area > 0 then
						self.currentFruitType = FruitUtil.FRUITTYPE_GRASS;
						self.lastArea = self.lastArea + area;
						 self.lastAreaBiggerZero = (self.lastArea > 0);
						realArea = realArea + area/g_currentMission.maxFruitValue;
					end;
				end;
				self.lastArea = self.lastArea*15;
			end;
		
			local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
			local qm = realArea*pixelToQm;
			local ha = qm/10000;
			
			g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
			g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

			g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
			g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);

		end;
	end;
                  for k,v in pairs(self.speedRotatingParts) do
                      if self.reelStarted and self.movingDirection < 0 then
                              rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
                       end;                    
                  end;
end;


function pickupGrassSwads:draw()	

end;

function pickupGrassSwads:onAttach(attacherVehicle)
end;

function pickupGrassSwads:onDetach()

end;

function pickupGrassSwads:onLeave()

end;

function pickupGrassSwads:onDetach()

end;