--
-- Hydraulics
-- Specialization for hydraulic animation
--
-- 
-- @author  Manuel Leithner (name changed by Bayn)
-- @date  18/04/10
--

Hydraulics = {};

function Hydraulics.prerequisitesPresent(specializations)
    return true;
end;

function Hydraulics:load(xmlFile)

	self.HydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Hydraulics#count"), 0);	
	if self.HydraulicsCount == 0 then
        print("Error: No Hydraulics specified - Count: 0", configFile);
    end;
	
	self.Hydraulics = {};	
	for i=1, self.HydraulicsCount do
		local hydraulicName = string.format("vehicle.Hydraulics.Hydraulic%d", i);
		
		self.Hydraulics[i] = {};		
		self.Hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#hydraulic"));
		self.Hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#hydraulicPunch"));
		self.Hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#hydraulicPunchFixPoint"));
		self.Hydraulics[i].FixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#FixPoint"));
		local ax, ay, az = getWorldTranslation(self.Hydraulics[i].punch);
		local bx, by, bz = getWorldTranslation(self.Hydraulics[i].translationPunch);		
		self.Hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;
end;

function Hydraulics:delete()
end;

function Hydraulics:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hydraulics:keyEvent(unicode, sym, modifier, isDown)
end;

function Hydraulics:update(dt)

	for i=1, table.getn(self.Hydraulics) do
		local ax, ay, az = getWorldTranslation(self.Hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.Hydraulics[i].FixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.Hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.Hydraulics[i].node, x, y, z, 0, 1, 0);
		if self.Hydraulics[i].punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.Hydraulics[i].punch, 0, 0, distance-self.Hydraulics[i].punchDistance);
		end;	
	end;
		
end;

function Hydraulics:draw()
end;
