Chock = {};

function Chock.prerequisitesPresent(specializations)
    return true;
end;

function Chock:load(xmlFile)

	self.attachedVisibility = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chock#attached"));
	self.detachedVisibility = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chock#detached"));
	setVisibility(self.attachedVisibility, false);
	setVisibility(self.detachedVisibility, true);

end;

function Chock:delete()
end;

function Chock:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Chock:keyEvent(unicode, sym, modifier, isDown)
end;

function Chock:update(dt)

end;

function Chock:updateTick(dt)
end;

function Chock:draw()
end;

function Chock:onAttach(attacherVehicle)
	setVisibility(self.attachedVisibility, true);
	setVisibility(self.detachedVisibility, false);
	if self.firstTimeRun and self.updateWheels and self.isServer then
		for i=1, table.getn(self.wheels) do
			local wheel = self.wheels[i];
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 2, wheel.steeringAngle);
		end;
	end;
end;

function Chock:onDetach()
	setVisibility(self.attachedVisibility, false);
	setVisibility(self.detachedVisibility, true);
	if self.firstTimeRun and self.updateWheels and self.isServer then
		for i=1, table.getn(self.wheels) do
			local wheel = self.wheels[i];
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 50, wheel.steeringAngle);
		end;
	end;
end;