--
-- E327B specialization
-- @author		Burner
-- @date		20.07.2012
--

E327B = {};

function E327B.prerequisitesPresent(specializations)
    return true;
end;

function E327B:load(xmlFile)
	self.UVScrollParts = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.UVScrollParts.UVScrollPart(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
		if node ~= nil and speed then
			table.insert(self.UVScrollParts, {node=node, speed=speed, currentLength=0});
		end;
		i = i +1;
	end;
end;

function E327B:delete()
end;

function E327B:mouseEvent(posX, posY, isDown, isUp, button)
end;

function E327B:keyEvent(unicode, sym, modifier, isDown)
end;

function E327B:update(dt)
    if self:getIsActiveForInput() then
		if self.attacherVehicle ~= nil and self.attacherVehicle.isMotorStarted then
			if InputBinding.isPressed(InputBinding.E327B_ReelUp) then
				if self.animationParts[1].clipEndTime == false then
					self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
				end;
			elseif InputBinding.isPressed(InputBinding.E327B_ReelDown) then
				if self.animationParts[1].clipStartTime == false then
					self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
				end;
			end;
		end;
    end;
	if self.isTurnedOn then
		self:setAnimationTime(2, 1);
	else
		self:setAnimationTime(2, 0);
	end;
	if self.isTurnedOn then
		for k, part in pairs(self.UVScrollParts) do
			part.currentLength = part.currentLength + 1;
			setShaderParameter(part.node, "UVPlaySpeed", part.currentLength*part.speed[1], part.currentLength*part.speed[2], 0, 0, false);
		end;
	end;
end;

function E327B:updateTick(dt)
end;

function E327B:draw()
	if self.isClient then
		if self.attacherVehicle ~= nil and self.attacherVehicle.isMotorStarted then
			g_currentMission:addExtraPrintText(string.format(""..string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.E327B_ReelUp), "PAD ", "") .. "/" .. string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.E327B_ReelDown), "PAD", "")..": "..g_i18n:getText("E327B_ReelMove")..""));
		end;
	end;
end;

function E327B:onAttach(attacherVehicle)
end;

function E327B:onDetach()
end;

function E327B:onLeave()
end;

function E327B:onDeactivate()
end;

function E327B:onDeactivateSounds()
end;