--
-- JD625R
-- 
--
-- @author  MySQly
-- @date  15/08/11
--
-- Copyright (C) MySQly, Confidential, All Rights Reserved.

JD625R = {};
source("dataS/scripts/vehicles/specializations/CutterAreaEvent.lua");
  
function JD625R.prerequisitesPresent(specializations)
    return true;
end;
  
function JD625R:load(xmlFile)
	self.nozeT = 100;
	self.reelSpeedOwn = 0.003;
	self.hederNisko = false;
	self.percentArea = 0;
	self.vehicleAttacher = nil;
	
	self.hydraulicPartTransport = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulicParts#transport"));
	self.hydraulicPartWork = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulicParts#work"));
	setVisibility(self.hydraulicPartWork, false);
	self.rotationMaxKardana = false;
	
	--AI Markers
    self.aiLeftMarkerLong1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index2"));
    self.aiRightMarkerLong1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index2"));
	
    self.aiLeftMarkerLong2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index3"));
    self.aiRightMarkerLong2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index3"));
	
    self.aiLeftMarkerLong3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index4"));
    self.aiRightMarkerLong3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index4"));
	--AI Markers
	
	
	self.particleSystemsSloma = {};
    local particleSystemsSlomaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsSloma#count"), 0);
    for i=1, particleSystemsSlomaCount do
        local namei = string.format("vehicle.particleSystemsSloma.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsSloma, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
    local rotationPartNodeKardana = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKardana#index"));
    if rotationPartNodeKardana ~= nil then
        self.rotationPartKardana = {};
        self.rotationPartKardana.node = rotationPartNodeKardana;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKardana#minRot"));
        self.rotationPartKardana.minRot = {};
        self.rotationPartKardana.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKardana.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKardana.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKardana#maxRot"));
        self.rotationPartKardana.maxRot = {};
        self.rotationPartKardana.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKardana.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKardana.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKardana.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKardana#rotTime"), 2)*1000;
        self.rotationPartKardana.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKardana#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeRozdzielacz1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz1#index"));
    if rotationPartNodeRozdzielacz1 ~= nil then
        self.rotationPartRozdzielacz1 = {};
        self.rotationPartRozdzielacz1.node = rotationPartNodeRozdzielacz1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz1#minRot"));
        self.rotationPartRozdzielacz1.minRot = {};
        self.rotationPartRozdzielacz1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRozdzielacz1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRozdzielacz1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz1#maxRot"));
        self.rotationPartRozdzielacz1.maxRot = {};
        self.rotationPartRozdzielacz1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRozdzielacz1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRozdzielacz1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRozdzielacz1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz1#rotTime"), 2)*1000;
        self.rotationPartRozdzielacz1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz1#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeRozdzielacz2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz2#index"));
    if rotationPartNodeRozdzielacz2 ~= nil then
        self.rotationPartRozdzielacz2 = {};
        self.rotationPartRozdzielacz2.node = rotationPartNodeRozdzielacz2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz2#minRot"));
        self.rotationPartRozdzielacz2.minRot = {};
        self.rotationPartRozdzielacz2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRozdzielacz2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRozdzielacz2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz2#maxRot"));
        self.rotationPartRozdzielacz2.maxRot = {};
        self.rotationPartRozdzielacz2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRozdzielacz2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRozdzielacz2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRozdzielacz2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz2#rotTime"), 2)*1000;
        self.rotationPartRozdzielacz2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRozdzielacz2#touchRotLimit"), 10));
    end;

    local rotationPartNodeMotowidla = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMotowidla#index"));
    if rotationPartNodeMotowidla ~= nil then
        self.rotationPartMotowidla = {};
        self.rotationPartMotowidla.node = rotationPartNodeMotowidla;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMotowidla#minRot"));
        self.rotationPartMotowidla.minRot = {};
        self.rotationPartMotowidla.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMotowidla.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMotowidla.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMotowidla#maxRot"));
        self.rotationPartMotowidla.maxRot = {};
        self.rotationPartMotowidla.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMotowidla.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMotowidla.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMotowidla.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMotowidla#rotTime"), 2)*1000;
        self.rotationPartMotowidla.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMotowidla#touchRotLimit"), 10));
    end;

	local translationPartNodeMotowidla = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartMotowidla#index"));
    if translationPartNodeMotowidla ~= nil then
        self.translationPartMotowidla = {};
        self.translationPartMotowidla.node = translationPartNodeMotowidla;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMotowidla#minTrans"));
        self.translationPartMotowidla.minTrans = {};
        self.translationPartMotowidla.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMotowidla.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMotowidla.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartMotowidla#maxTrans"));
        self.translationPartMotowidla.maxTrans = {};
        self.translationPartMotowidla.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartMotowidla.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartMotowidla.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartMotowidla.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMotowidla#transTime"), 2)*1000;
        self.translationPartMotowidla.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartMotowidla#touchTransLimit"), 10);
    end;
	
	local translationPartNodeNoz1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartNoz1#index"));
    if translationPartNodeNoz1 ~= nil then
        self.translationPartNoz1 = {};
        self.translationPartNoz1.node = translationPartNodeNoz1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz1#minTrans"));
        self.translationPartNoz1.minTrans = {};
        self.translationPartNoz1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz1#maxTrans"));
        self.translationPartNoz1.maxTrans = {};
        self.translationPartNoz1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartNoz1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz1#transTime"), 2)*1000;
        self.translationPartNoz1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz1#touchTransLimit"), 10);
    end;
	
	local translationPartNodeNoz2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartNoz2#index"));
    if translationPartNodeNoz2 ~= nil then
        self.translationPartNoz2 = {};
        self.translationPartNoz2.node = translationPartNodeNoz2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz2#minTrans"));
        self.translationPartNoz2.minTrans = {};
        self.translationPartNoz2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz2#maxTrans"));
        self.translationPartNoz2.maxTrans = {};
        self.translationPartNoz2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartNoz2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz2#transTime"), 2)*1000;
        self.translationPartNoz2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz2#touchTransLimit"), 10);
    end;
	
	local translationPartNodeNoz3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartNoz3#index"));
    if translationPartNodeNoz3 ~= nil then
        self.translationPartNoz3 = {};
        self.translationPartNoz3.node = translationPartNodeNoz3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz3#minTrans"));
        self.translationPartNoz3.minTrans = {};
        self.translationPartNoz3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz3#maxTrans"));
        self.translationPartNoz3.maxTrans = {};
        self.translationPartNoz3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartNoz3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz3#transTime"), 2)*1000;
        self.translationPartNoz3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz3#touchTransLimit"), 10);
    end;
	
	local translationPartNodeNoz4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartNoz4#index"));
    if translationPartNodeNoz4 ~= nil then
        self.translationPartNoz4 = {};
        self.translationPartNoz4.node = translationPartNodeNoz4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz4#minTrans"));
        self.translationPartNoz4.minTrans = {};
        self.translationPartNoz4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartNoz4#maxTrans"));
        self.translationPartNoz4.maxTrans = {};
        self.translationPartNoz4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartNoz4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartNoz4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartNoz4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz4#transTime"), 2)*1000;
        self.translationPartNoz4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartNoz4#touchTransLimit"), 10);
    end;
	
    self.rzepak = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rzepak#index1"));
    self.rozdzielacze = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rzepak#index2"));
	self.stolRzepak = false;
	setVisibility(self.rzepak, self.stolRzepak);
	setVisibility(self.rozdzielacze, not self.stolRzepak);
  
  
  --***************************************************************************************************************
    self.setReelSpeedScale = SpecializationUtil.callSpecializationsFunction("setReelSpeedScale");
    self.onStartReel = SpecializationUtil.callSpecializationsFunction("onStartReel");
    self.onStopReel = SpecializationUtil.callSpecializationsFunction("onStopReel");
    self.isReelStarted = JD625R.isReelStarted;
    self.resetFruitType = SpecializationUtil.callSpecializationsFunction("resetFruitType");
    self.setFruitType = SpecializationUtil.callSpecializationsFunction("setFruitType");
    self.getInputFruitType = JD625R.getInputFruitType;
 
    self.reelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));
    self.reelSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reel#speed"), 0.003);
  
    self.reelSpeedScale = 1;
  
    self.rollNodes = {};
 
    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
   
    local indexSpikesStr = getXMLString(xmlFile, "vehicle.reelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.reelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);
  
    self.sideArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#index"));
    self.sideArmMovable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);
 
    self.threshingParticleSystems = {};
    local psName = "vehicle.threshingParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, psName, self.components, false, nil, self.baseDirectory)
  
    self.fruitExtraObjects = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.fruitExtraObjects.fruitExtraObject(%d)", i);
        local t = getXMLString(xmlFile, key.."#fruitType");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            if self.currentExtraObject == nil then
                self.currentExtraObject = node;
                setVisibility(node, true);
            else
                setVisibility(node, false);
            end;
            self.fruitExtraObjects[t] = node;
        end;
        i = i +1;
    end;
  
    self.threshingUVScrollParts = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.threshingUVScrollParts.threshingUVScrollPart(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.threshingUVScrollParts, {node=node, speed=speed});
        end;
        i = i +1;
    end;
  
    self.preferedCombineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.preferedCombineSize"), 1);
  
    self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;
  
    self.convertedFruits = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.convertedFruits.convertedFruit(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local inputType = getXMLString(xmlFile, key .. "#input");
        local outputType = getXMLString(xmlFile, key .. "#output");
  
        if inputType ~= nil and outputType ~= nil then
            local inputDesc = FruitUtil.fruitTypes[inputType];
            local outputDesc = FruitUtil.fruitTypes[outputType];
            if inputDesc ~= nil and outputDesc ~= nil then
                self.convertedFruits[inputDesc.index] = outputDesc.index;
            end;
        end;
  
        i = i + 1;
    end;
  
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.currentInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
  
    self.reelStarted = false;
 
    self.forceLowSpeed = false;
    self.speedLimitLow = 12;
    self.speedLimit = 17.5;
 
    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;
    self.printRainWarning = false;
  
    self.lastArea = 0;
    self.lastAreaBiggerZero = self.lastArea > 0;
 
    self.cutterGroundFlag = self:getNextDirtyFlag();
  
end;
  
function JD625R:delete()
    Utils.deleteParticleSystem(self.threshingParticleSystems);
end;
  
function JD625R:readStream(streamId, timestamp, connection)
    self.lastAreaBiggerZero = streamReadBool(streamId);
end;
  
function JD625R:writeStream(streamId, connection, dirtyMask)
    streamWriteBool(streamId, self.lastAreaBiggerZero);
end;
  
function JD625R:readUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        self.lastAreaBiggerZero = streamReadBool(streamId);
    end;
end;
  
function JD625R:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        streamWriteBool(streamId, self.lastAreaBiggerZero);
    end;
end;
  
function JD625R:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function JD625R:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_KP_5 then
		self.stolRzepak = not self.stolRzepak;
	end;
	
    if isDown and sym == Input.KEY_KP_7 then
		self.reelSpeedOwn = self.reelSpeedOwn - 0.001;
		if self.reelSpeedOwn < 0.001 then
			self.reelSpeedOwn = 0.001;
		end;
	end;
    if isDown and sym == Input.KEY_KP_9 then
		self.reelSpeedOwn = self.reelSpeedOwn + 0.001;
		if self.reelSpeedOwn > 0.005 then
			self.reelSpeedOwn = 0.005;
		end;
	end;
	
	if self.attacherVehicle ~= nil then
		if sym == Input.KEY_KP_8 then
			self.rotationMaxMotowidla = isDown;
			self.attacherVehicle.hydraulicSoundPlay = isDown;
		end;
		if sym == Input.KEY_KP_2 then
			self.rotationMinMotowidla = isDown;
			self.attacherVehicle.hydraulicSoundPlay = isDown;
		end;
		if sym == Input.KEY_KP_4 then
			self.translationMaxMotowidla = isDown;
			self.attacherVehicle.hydraulicSoundPlay = isDown;
		end;
		if sym == Input.KEY_KP_6 then
			self.translationMinMotowidla = isDown;
			self.attacherVehicle.hydraulicSoundPlay = isDown;
		end;
	end;
end;
  
function JD625R:update(dt)
  
    if self.attacherVehicle ~= nil and self.attacherVehicle.deactivateCutter then
        JD625R.onDeactivate(self);
		self.attacherVehicle.deactivateCutter = false;
    end;
	self.percentArea = 0;
	if self.attacherVehicle ~= nil then
		self.hederNisko = self.attacherVehicle.cutterLowPosition;
	end;
	
	if self.reelStarted then
		self.nozeT = self.nozeT + dt;
		if self.nozeT > 100 then
			self.translationMaxNoz1 = not self.translationMaxNoz1;
			self.translationMaxNoz2 = not self.translationMaxNoz2;
			self.translationMaxNoz3 = not self.translationMaxNoz3;
			self.translationMaxNoz4 = not self.translationMaxNoz4;
			self.nozeT = 0;
		end;
	end;
	
	setVisibility(self.rzepak, self.stolRzepak);
	setVisibility(self.rozdzielacze, not self.stolRzepak);
	
	if self.rotationPartKardana ~= nil then
		local x, y, z = getRotation(self.rotationPartKardana.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartKardana.maxRot, self.rotationPartKardana.minRot, 3, self.rotationPartKardana.rotTime, dt, not self.rotationMaxKardana);
		setRotation(self.rotationPartKardana.node, unpack(newRot));
	end;
	
	if self.translationPartNoz1 ~= nil then
		local x, y, z = getTranslation(self.translationPartNoz1.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartNoz1.maxTrans, self.translationPartNoz1.minTrans, 3, self.translationPartNoz1.transTime, dt, not self.translationMaxNoz1);
		setTranslation(self.translationPartNoz1.node, unpack(newTrans));
	end;
	
	if self.translationPartNoz2 ~= nil then
		local x, y, z = getTranslation(self.translationPartNoz2.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartNoz2.maxTrans, self.translationPartNoz2.minTrans, 3, self.translationPartNoz2.transTime, dt, not self.translationMaxNoz2);
		setTranslation(self.translationPartNoz2.node, unpack(newTrans));
	end;
	
	if self.translationPartNoz3 ~= nil then
		local x, y, z = getTranslation(self.translationPartNoz3.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartNoz3.maxTrans, self.translationPartNoz3.minTrans, 3, self.translationPartNoz3.transTime, dt, not self.translationMaxNoz3);
		setTranslation(self.translationPartNoz3.node, unpack(newTrans));
	end;
	
	if self.translationPartNoz4 ~= nil then
		local x, y, z = getTranslation(self.translationPartNoz4.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartNoz4.maxTrans, self.translationPartNoz4.minTrans, 3, self.translationPartNoz4.transTime, dt, not self.translationMaxNoz4);
		setTranslation(self.translationPartNoz4.node, unpack(newTrans));
	end;
	
	if self.rotationPartRozdzielacz1 ~= nil then
		local x, y, z = getRotation(self.rotationPartRozdzielacz1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRozdzielacz1.maxRot, self.rotationPartRozdzielacz1.minRot, 3, self.rotationPartRozdzielacz1.rotTime, dt, not self.rotationMaxRozdzielacz1);
		setRotation(self.rotationPartRozdzielacz1.node, unpack(newRot));
	end;
	
	if self.rotationPartRozdzielacz2 ~= nil then
		local x, y, z = getRotation(self.rotationPartRozdzielacz2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRozdzielacz2.maxRot, self.rotationPartRozdzielacz2.minRot, 3, self.rotationPartRozdzielacz2.rotTime, dt, not self.rotationMaxRozdzielacz2);
		setRotation(self.rotationPartRozdzielacz2.node, unpack(newRot));
	end;
	
	local doTranslate = self.translationMaxMotowidla or self.translationMinMotowidla
	if self.translationPartMotowidla ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPartMotowidla.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartMotowidla.maxTrans, self.translationPartMotowidla.minTrans, 3, self.translationPartMotowidla.transTime, dt, not self.translationMaxMotowidla);
		setTranslation(self.translationPartMotowidla.node, unpack(newTrans));
	end;
	
    if self.rotationPartMotowidla ~= nil and (self.rotationMaxMotowidla or self.rotationMinMotowidla) then
        local x, y, z = getRotation(self.rotationPartMotowidla.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMotowidla.maxRot, self.rotationPartMotowidla.minRot, 3, self.rotationPartMotowidla.rotTime, dt, not self.rotationMaxMotowidla);
        setRotation(self.rotationPartMotowidla.node, unpack(newRot));
    end;
	
	--*************************************************************************************
  
    Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastAreaBiggerZero));
	Utils.setEmittingState(self.particleSystemsSloma, (self.reelStarted and self.lastAreaBiggerZero));
  
    if self.reelStarted then 
        for _, rollNode in pairs(self.rollNodes) do
            rotate(rollNode.node, dt*self.reelSpeedOwn*3, 0, 0);
        end;
  
        if self.reelNode ~= nil then
            rotate(self.reelNode, -dt*self.reelSpeedOwn, 0, 0);
  
            if self.sideArmMovable then
                --:TODO: move arm downwards
            end;
  
            --correct spikes, so that they always look down
            local atx, aty, atz = getRotation(self.reelNode);
  
            for i=1, self.spikesCount do
                local spike = getChildAt(self.spikesRootNode, i-1);
                --local tx, ty, tz = getRotation(spike);
                rotate(spike, dt*self.reelSpeedOwn, 0, 0);
            end;
        end;
  
    end;
end;
  
function JD625R:updateTick(dt)
    if self.isServer then
        self.lastArea = 0;
        self.printRainWarning = false;
    end;
    if self.reelStarted and self.movingDirection < 0 then
        local speedLimit = self.speedLimit;
        if JD625R.getUseLowSpeedLimit(self) then
            speedLimit = self.speedLimitLow;
        end;
  
        if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
            self.speedViolationTimer = self.speedViolationTimer - dt;
        else
            self.speedViolationTimer = self.speedViolationMaxTime;
        end;
        if self.isServer then
  
            if self.speedViolationTimer > 0 then
                local isAllowed = true;
                if self.attacherVehicle ~= nil then
                    isAllowed = self.attacherVehicle:getIshreshingAllowed(false);
                end;
                if isAllowed then
                    -- during low fill level new fruit types are allowed to "take over"
                    local lowFillLevel = false;
                    if self.attacherVehicle ~= nil then
                        if self.attacherVehicle.grainTankFillLevel == 0 or self.attacherVehicle.grainTankFillLevel / self.attacherVehicle.grainTankCapacity <= self.attacherVehicle.minThreshold then
                            lowFillLevel = true;
                        end;
                    end;
  
                    local foundFruitType = false;
                    local oldFruitType = self.currentFruitType;
                    local oldInputFruitType = self.currentInputFruitType;
 
                    local allowsThreshing = true;
                    if self.attacherVehicle ~= nil then
                        allowsThreshing = self.attacherVehicle.allowsThreshing;
                    end;
  
                    if allowsThreshing then
                        if self.currentFruitType == FruitUtil.FRUITTYPE_UNKNOWN or lowFillLevel then
                            for fruitType,v in pairs(self.fruitTypes) do
                                local outputFruitType = fruitType;
                                if self.convertedFruits[fruitType] ~= nil then
                                    outputFruitType = self.convertedFruits[fruitType];
                                end;
  
                                local isOk = true;
                                if self.attacherVehicle ~= nil then
                                    if self.attacherVehicle.allowGrainTankFruitType ~= nil then
                                        isOk = self.attacherVehicle:allowGrainTankFruitType(outputFruitType);
                                    end;
                                end;
                                if isOk then
                                    for k,area in pairs(self.cuttingAreas) do
                                        local x,y,z = getWorldTranslation(area.start);
                                        local x1,y1,z1 = getWorldTranslation(area.width);
                                        local x2,y2,z2 = getWorldTranslation(area.height);
                                        local area = Utils.getFruitArea(fruitType, x, z, x1, z1, x2, z2);
                                        if area > 0 then
                                            self.currentFruitType = outputFruitType;
                                            self.currentInputFruitType = fruitType;
                                            if self.currentInputFruitType ~= oldInputFruitType then
                                                JD625R.updateExtraObjects(self)
                                                if self.attacherVehicle ~= nil then
                                                    self.attacherVehicle:emptyGrainTankIfLowFillLevel();
                                                end;
                                            end;
                                            foundFruitType = true;
                                            break;
                                        end;
                                    end;
  
                                    if foundFruitType then
                                        break;
                                    end;
                                end;
                            end;
                        end;
                        if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 
                            --local realArea = 0;
                            local cuttingAreasSend = {};
                            for k,area in pairs(self.cuttingAreas) do
                                if self:getIsAreaActive(area) then
                                    local x,y,z = getWorldTranslation(area.start);
                                    local x1,y1,z1 = getWorldTranslation(area.width);
                                    local x2,y2,z2 = getWorldTranslation(area.height);
                                    table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                end;
                            end;
                            if (table.getn(cuttingAreasSend) > 0) then
                                local lastArea, realArea = CutterAreaEvent.runLocally(cuttingAreasSend, self.currentInputFruitType);
                                self.lastArea = lastArea;
                                self.lastAreaBiggerZero = (self.lastArea > 0);
                                if self.lastArea > 0 then
                                    g_server:broadcastEvent(CutterAreaEvent:new(cuttingAreasSend, self.currentInputFruitType));
                                end;
                                if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
                                    self:raiseDirtyFlags(self.cutterGroundFlag);
                                    self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
                                end;
                                local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
                                local sqm = realArea*pixelToSqm;
                                local ha = sqm/10000;
								
								self.percentArea = realArea;
								
                                g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
                                g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;
                            end;
  
                            g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
                            g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
                        end;
                    end;
                else
                    self.printRainWarning = true;
                end;
            end;
        end;
    else
        self.speedViolationTimer = self.speedViolationMaxTime;
    end;
end;
  
function JD625R:draw()
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.help then
			--setTextColor(0.75, 0.75, 0.75, 1.0);
			renderText(0.8, 0.7, 0.022, "KP 1 - Hillmaster left");
			renderText(0.8, 0.674, 0.022, "KP 3 - Hillmaster right");
			renderText(0.8, 0.648, 0.022, "KP 8 - Reel up");
			renderText(0.8, 0.622, 0.022, "KP 2 - Reel down");
			renderText(0.8, 0.596, 0.022, "KP 4 - Reel forward");
			renderText(0.8, 0.57, 0.022, "KP 6 - Reel backward");
			renderText(0.8, 0.544, 0.022, "KP 7 - Reel speed -");
			renderText(0.8, 0.518, 0.022, "KP 9 - Reek speed +");
			renderText(0.8, 0.492, 0.022, "KP 5 - Rape table");
			renderText(0.8, 0.466, 0.022, string.format("Reel speed: %.0f", self.reelSpeedOwn*1000));
			renderText(0.8, 0.44, 0.022, " ");
			renderText(0.8, 0.414, 0.022, " ");
			--setTextColor(1.0, 1.0, 1.0, 1.0);
			self.attacherVehicle.hudjohndeere625ROverlay:render();
		end;
	end;
end;

function JD625R:onAttach()
	if self.attacherVehicle.heder then
		self.rotationMaxRozdzielacz2 = true;
		self.rotationMaxRozdzielacz1 = true;	
		self.rotationMaxKardana = true;	
		setVisibility(self.hydraulicPartTransport, false);
		setVisibility(self.hydraulicPartWork, true);
	end;
	self.hederNisko = false;
	self.vehicleAttacher = self.attacherVehicle;
	self.vehicleAttacher.cutterName = "jd625r";
	self.vehicleAttacher.cutterOpened = true;
	self.vehicleAttacher.changeAttacherMaxRotation = true;
end;

function JD625R:onDetach()
    if self.deactivateOnDetach then
        JD625R.onDeactivate(self);
    end;
	self.rotationMaxRozdzielacz2 = false;
	self.rotationMaxRozdzielacz1 = false;
	self.rotationMaxKardana = false;
	setVisibility(self.hydraulicPartTransport, true);
	setVisibility(self.hydraulicPartWork, false);
	self.hederNisko = false;
	self.vehicleAttacher.cutterName = "nil";
end;
  
function JD625R:onLeave()
    if self.deactivateOnLeave then
        JD625R.onDeactivate(self);
    end;
end;
  
function JD625R:onDeactivate()
    self:onStopReel();
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;
  
function JD625R:setReelSpeedSpace(speedScale)
    self.reelSpeedScale = speedScale;
end;
  
function JD625R:onStartReel()
    self.reelStarted = true;
  
    for _, part in pairs(self.threshingUVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
    end;
end;
  
function JD625R:onStopReel()
    self.reelStarted = false;
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
  
    for _, part in pairs(self.threshingUVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
end;
  
function JD625R:isReelStarted()
    return self.reelStarted;
end;
  
function JD625R:resetFruitType()
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.currentInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastArea = 0;
end;
 
function JD625R:setFruitType(fruitType)
    if self.currentInputFruitType ~= fruitType then
        self.currentInputFruitType = fruitType;
        self.currentFruitType = fruitType;
        if self.convertedFruits[fruitType] ~= nil then
            self.currentFruitType = self.convertedFruits[fruitType];
        end;
        self.lastArea = 0;
 
        JD625R.updateExtraObjects(self)
    end;
end;
  
function JD625R.getUseLowSpeedLimit(self)
    if self.forceLowSpeed or (self.attacherVehicle ~= nil and self.preferedCombineSize > self.attacherVehicle.combineSize) then
        return true;
    end;
    return false;
end;
  
function JD625R.updateExtraObjects(self)
    if self.currentExtraObject ~= nil then
        setVisibility(self.currentExtraObject, false);
        self.currentExtraObject = nil;
    end;
    if self.currentInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local name = FruitUtil.fruitIndexToDesc[self.currentInputFruitType].name;
        local extraObject = self.fruitExtraObjects[name];
        if extraObject ~= nil then
            setVisibility(extraObject, true);
            self.currentExtraObject = extraObject;
        end;
    end;
end;
  
-- Deprecated, use Combine.getIshreshingAllowed
function JD625R.allowThreshing(earlyWarning)
    if earlyWarning ~= nil and earlyWarning == true then
        if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    else
        if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    end;
    return false;
end;