--
-- dynamicLoad
-- Specialization for physically adapting Camera
--
-- @author  Knagsted
-- @date  3/04/10
--

-- Do not edit without my permission
--
dynamicLoad = {};

function dynamicLoad.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(powerShift, specializations);
end;

function dynamicLoad:load(xmlFile)
	self.balerTimeOffSet = 0;
	self.balerSoundDuration = 1240;
	self.balerTimeout = self.balerTimeOffSet;
	
	self.dynamicLoadForce = 0;
	self.lastDynamicLoadForce = 0;
	self.showExtraLoadParticles = false;
	
	self.currentTime = 0;
end;

function dynamicLoad:delete()
end;

function dynamicLoad:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dynamicLoad:keyEvent(unicode, sym, modifier, isDown)
end;

function dynamicLoad:update(dt)
end;

function dynamicLoad:updateTick(dt)
	if self.enabledPowershiftGearBox and not self.isAITractorActivated and not self.isAutopilotActivated then
		local lowered = false;
		for k, implement in pairs(self.attachedImplements) do
			if implement.object ~= nil then
				if implement.object.allowsLowering then
					local jointDesc = self.attacherJoints[implement.jointDescIndex];
					if jointDesc.allowsLowering and jointDesc.moveDown then
						lowered = true;
						--renderText(0.5, 0.1, 0.016, string.format("Lowered"));
					--elseif not lowered then
						--self.dynamicLoadForce = 0;
					end;
				elseif implement.object.cultivatorHasGroundContact or implement.object.ploughHasGroundContact or implement.object.sowingMachineHasGroundContact then
					lowered = true;
					--renderText(0.5, 0.1, 0.016, string.format("cultivator"));
				elseif (implement.object.isTurnedOn or implement.object.reelStarted or implement.object.isLowering or implement.object.lowerBooms) and implement.object.baleTypes == nil then
					lowered = true;
					--renderText(0.5, 0.1, 0.016, string.format("turned on"));
				elseif implement.object.MovingPartsMax ~= nil and not implement.object.MovingPartsMax then
					lowered = true;
					--renderText(0.5, 0.1, 0.016, string.format("mooving part max"));
				end;
			end;
		end;
		
		if lowered and ((self.lastSpeed * 3600) > 0.1 or (self.lastSpeed * 3600) < -0.1) and self.myCurrentGear ~= 0 then
			self.myAccelerationOffset = -0.0075 * math.random(10,20);
		else
			self.myAccelerationOffset = 0;	
		end;
		
		
				
		--Handle pull types like baler or trailer
		local balerOn = false;
		local roundBalerOn = false;
		local weightFactor = 0;
		local lifting = false;
		local myBaler = nil;
		for k, implement in pairs(self.attachedImplements) do
			if implement.object ~= nil then
				if implement.object.isTurnedOn and implement.object.baleTypes ~= nil then
					if implement.object.balerDoorEnabled == nil then
						balerOn = true;
						myBaler = implement.object;
						self.balerSoundDuration =  getSampleDuration(myBaler.balerSound);
						--renderText(0.5, 0.1, 0.016, string.format(self.balerSoundDuration));
					else
						roundBalerOn = true;
					end;
				elseif implement.object.fillLevel ~= nil and implement.object.fillLevel > 0 then
					weightFactor = implement.object.fillLevel/120000;
					if implement.object.tipState ~= nil and implement.object.tipState == Trailer.TIPSTATE_OPENING then
						lifting = true;
					end;
				end;
			end;
		end;
		
		if balerOn then
			if self.balerTimeout <= self.time then
				stopSample(myBaler.balerSound);
				playSample(myBaler.balerSound, 0, myBaler.balerSoundVolume, 0);
				self.balerTimeout = self.time + self.balerSoundDuration;
				self.dynamicLoadForce = 0.15;
			end;
			self.myLastAcceleration = self.myLastAcceleration - self.dynamicLoadForce;
			self.dynamicLoadForce = 0;
			
			if self.myLastAcceleration < 0.1 then
				self.myLastAcceleration = 0.1;
			end;
		elseif roundBalerOn then
			self.myAccelerationOffset = -0.0075 * math.random(10,20);
		elseif weightFactor > 0 and (((self.lastSpeed * 3600 > 0.1 or self.lastSpeed * 3600 < -0.1) and self.myCurrentGear ~= 0) or lifting) then
			self.myAccelerationOffset = self.myAccelerationOffset - weightFactor;
		end;
		
			--handle dynamic loading
		--[[if self.dynamicLoadForce > 0 and self.myCurrentGear == self.myLastGear then
			if self.dynamicLoadForce > 0.5 then
				self.dynamicLoadForce = 0.5
			end;
			
			renderText(0.5, 0.1, 0.016, string.format(self.dynamicLoadForce));
			
			--self.myLastAcceleration = self.myLastAcceleration - self.dynamicLoadForce;
			
			self.myLastAcceleration = self.newAcceleration - self.dynamicLoadForce;
			
			if self.myLastAcceleration < 0.2 then
				self.myLastAcceleration = 0.2;
			end;
		end;]]
		
		--renderText(0.5, 0.2, 0.016, string.format(self.myLastAcceleration));
		
		if not self.showExtraParticles then
			if self.dynamicLoadForce > 0 and self.isMotorStarted then
				self.showExtraLoadParticles = true;
			else
				self.showExtraLoadParticles = false;
			end;
		
		--Extra smoke particles
			Utils.setEmittingState(self.extraExhaustParticleSystems, self.showExtraLoadParticles);
		end;
	end;
end;

function dynamicLoad:onLeave()
end;

function dynamicLoad:onEnter()
end;

function dynamicLoad:startMotor()
end;

function dynamicLoad:draw()
end;

