
courseplayMouseOverride = {};

function courseplayMouseOverride.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function courseplayMouseOverride:load(xmlFile)
	self.hudTriggered = false;
	self.powershiftWasEnabled = self.enabledPowershiftGearBox;
	self.myPreviousCurrentGear = 0;
	self.myPreviousCurrentGearLevel = 0;
end;

function courseplayMouseOverride:delete()
end;

function courseplayMouseOverride:mouseEvent(posX, posY, isDown, isUp, button)
end;

function courseplayMouseOverride:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_insert and self.isEntered then
		self.hudTriggered = not self.hudTriggered;

		--[[if self.hudTriggered then
			self.myPreviousCurrentGear = self.myCurrentGear;
			self.myPreviousCurrentGearLevel = self.myCurrentGearLevel;
			self.powershiftWasEnabled = self.enabledPowershiftGearBox;
			self.enabledPowershiftGearBox = false;
		else
			self.myCurrentGear = self.myPreviousCurrentGear;
			self.myCurrentGearLevel = self.myPreviousCurrentGearLevel;
			self.enabledPowershiftGearBox = self.powershiftWasEnabled;
		end;]]

		if self.mouse_enabled then
		  self.mouse_enabled = false
		  if self.show_hud then
			self.show_hud = false
		  end
		else
		  self.mouse_enabled = true	    
		  if not self.show_hud then
			self.showHudInfoBase = self.min_hud_page
			self.show_hud = true
		  end
		end
		InputBinding.setShowMouseCursor(self.mouse_enabled)
		
		self.soundSwitched = true;
	end
end;

function courseplayMouseOverride:update(dt)
	if not self.hudTriggered and self.show_hud then
	  self.mouse_enabled = false;
	  self.show_hud = false;
	  InputBinding.setShowMouseCursor(self.mouse_enabled);
	end;
	
	if self.hudTriggered or self.show_hud then
		self.enabledPowershiftGearBox = false;
	end;
end;

function courseplayMouseOverride:onLeave()
end;

function courseplayMouseOverride:draw()
end;

